<?php
/**
 * Azo Wishlist Widget
 *
 * @package azo
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class for azo elementor product images widget.
 */
class Azo_Wishlist extends \Elementor\Widget_Base {
	/**
	 * Category
	 */
	public function get_categories() {
		return array( 'azo-theme' );
	}

	/**
	 * Name
	 */
	public function get_name() {
		return 'azo-wishlist';
	}

	/**
	 * Gets the title.
	 */
	public function get_title() {
		return __( 'Wishlist', 'azo' );
	}

	/**
	 * Gets the icon.
	 */
	public function get_icon() {
		return 'eicon-heart-o';
	}

	/**
	 * Controls
	 */
	protected function register_controls() { //phpcs:ignore
		$this->content();
		$this->style();
	}

	/**
	 * Render
	 */
	public function render() {
		$settings = $this->get_settings_for_display();
		?>
		<div class="wishlist-azo-widget">
			<?php echo wp_kses( azo_wishlist(), azo_get_allowed_html() ); ?>
		</div>
		<?php
	}

	/**
	 * Content
	 */
	protected function content() {
		$this->start_controls_section(
			'Wishlist',
			array(
				'label' => __( 'Wishlist', 'azo' ),
			)
		);

		$this->add_responsive_control(
			'section_position',
			array(
				'type'           => Controls_Manager::CHOOSE,
				'label'          => esc_html__( 'Alignment', 'azo' ),
				'options'        => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'azo' ),
						'icon'  => 'fa fa-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'azo' ),
						'icon'  => 'fa fa-align-center',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'azo' ),
						'icon'  => 'fa fa-align-right',
					),
				),
				'default'        => 'center',
				'tablet_default' => 'center',
				'mobile_default' => 'center',
				'selectors'      => array(
					'{{WRAPPER}} .wishlist-azo-widget' => 'text-align: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'icon_typo',
			array(
				'label'     => esc_html__( 'Size icon', 'azo' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'min' => 1,
						'max' => 300,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .header-wishlist' => 'font-size: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
	}

	/**
	 * Style
	 */
	protected function style() {
		$this->start_controls_section(
			'title_style',
			array(
				'label' => esc_html__( 'Title', 'azo' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		// TAB START.
		$this->start_controls_tabs( 'wishlist_style_tabs' );

		// Normal.
		$this->start_controls_tab(
			'wishlist_style_normal',
			array(
				'label' => __( 'Normal', 'azo' ),
			)
		);

		// Color.
		$this->add_control(
			'wishlist_style_title_color',
			array(
				'label'     => __( 'Color Icon', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#222222',
				'selectors' => array(
					'{{WRAPPER}} .wishlist-azo-widget .header-wishlist:before' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'color_couter',
			array(
				'label'     => __( 'Color Couter', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#222222',
				'selectors' => array(
					'{{WRAPPER}} .wishlist-azo-widget .header-wishlist .count-wishlist' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'bg_title_color',
			array(
				'label'     => esc_html__( 'Background Couter Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#ffb700',
				'selectors' => array(
					'{{WRAPPER}} .wishlist-azo-widget .header-wishlist .count-wishlist' => 'background-color: {{VALUE}}',
				),
			)
		);

		// END NORMAL.
		$this->end_controls_tab();

		// HOVER.
		$this->start_controls_tab(
			'wishlist_style_hover',
			array(
				'label' => __( 'Hover', 'azo' ),
			)
		);

		// Hover color.
		$this->add_control(
			'wishlist_style_color',
			array(
				'label'     => __( 'Color Icon Hover', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .wishlist-azo-widget a.header-wishlist:hover:before' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'color_couter_hover',
			array(
				'label'     => __( 'Color Couter', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .wishlist-azo-widget .header-wishlist:hover .count-wishlist' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'bg_title_color_hover',
			array(
				'label'     => esc_html__( 'Background Couter Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .wishlist-azo-widget .header-wishlist:hover .count-wishlist' => 'background-color: {{VALUE}}',
				),
			)
		);

		// TAB END.
		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();

		$this->end_controls_section();
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Azo_Wishlist() );
