<?php
/**
 * Elementor Testimonial Widget
 *
 * @package azo
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class for azo elementor testimonail widget.
 */
class Azo_Testimonial extends \Elementor\Widget_Base {
	/**
	 * Category
	 */
	public function get_categories() {
		return array( 'azo-theme' );
	}

	/**
	 * Name
	 */
	public function get_name() {
		return 'azo-testimonial';
	}

	/**
	 * Gets the title.
	 */
	public function get_title() {
		return __( 'Testimonial Slider', 'azo' );
	}

	/**
	 * Gets the icon.
	 */
	public function get_icon() {
		return 'eicon-testimonial';
	}

	/**
	 * Retrieve the list of scripts the widget depended on
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return array( 'azo-testimonial' );
	}

	/**
	 * Controls
	 */
	protected function register_controls() { //phpcs:ignore

		$this->start_controls_section(
			'section_testimonial',
			array(
				'label' => esc_html__( 'Testimonial', 'azo' ),
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'testimonial_image',
			array(
				'label'   => esc_html__( 'Add Image', 'azo' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),
			)
		);

		$repeater->add_control(
			'title',
			array(
				'label'       => esc_html__( 'Title', 'azo' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter Title', 'azo' ),
				'default'     => esc_html__( 'Best personal coach ever', 'azo' ),
			)
		);

		$repeater->add_control(
			'name',
			array(
				'label'       => esc_html__( 'Name', 'azo' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter Name', 'azo' ),
				'default'     => esc_html__( 'Zane Mayes', 'azo' ),
			)
		);

		$repeater->add_control(
			'position-name',
			array(
				'label'       => esc_html__( 'Position Name', 'azo' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter Position Name', 'azo' ),
				'default'     => esc_html__( ' / Oakland', 'azo' ),
			)
		);

		$repeater->add_control(
			'rate',
			array(
				'label'   => esc_html__( 'Rate star', 'azo' ),
				'type'    => Controls_Manager::NUMBER,
				'min'     => 1,
				'max'     => 5,
				'step'    => 1,
				'default' => 5,
			)
		);

		$repeater->add_control(
			'content',
			array(
				'label'       => esc_html__( 'Content', 'azo' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter Content', 'azo' ),
				'default'     => esc_html__( 'Getting the coveted high-five in the hallway from an influence is impressive in its own right, but what’s really impressive and where you ought to focus your outreach efforts is getting press from influencers in your market.', 'azo' ),
			)
		);

		$this->add_control(
			'testimonial',
			array(
				'label'       => esc_html__( 'Testimonial', 'azo' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ name }}}',
				'default'     => array(
					array(),
					array(),
					array(),
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_layout',
			array(
				'label' => esc_html__( 'Layout', 'azo' ),
			)
		);

		$this->add_responsive_control(
			'section_position',
			array(
				'type'           => Controls_Manager::CHOOSE,
				'label'          => esc_html__( 'Alignment', 'azo' ),
				'options'        => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'azo' ),
						'icon'  => 'fa fa-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'azo' ),
						'icon'  => 'fa fa-align-center',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'azo' ),
						'icon'  => 'fa fa-align-right',
					),
				),
				'default'        => 'center',
				'tablet_default' => 'center',
				'mobile_default' => 'center',
				'selectors'      => array(
					'{{WRAPPER}} .testimonial-item' => 'text-align: {{VALUE}};',
				),
			)
		);

		// Slides to show.
		$this->add_responsive_control(
			'slides_to_show',
			array(
				'label'                 => esc_html__( 'Slides to show', 'azo' ),
				'type'                  => Controls_Manager::NUMBER,
				'min'                   => 1,
				'max'                   => 5,
				'step'                  => 1,
				'devices'               => array( 'desktop', 'tablet', 'mobile' ),
				'slides_to_show_mobile' => array( 'default' => 1 ),
				'slides_to_show_tablet' => array( 'default' => 2 ),
				'slides_to_show'        => array( 'default' => 3 ),
			)
		);

		$this->add_control(
			'show_image',
			array(
				'label'        => esc_html__( 'Show Image', 'azo' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => 'no',
				'label_on'     => esc_html__( 'No', 'azo' ),
				'label_off'    => esc_html__( 'Yes', 'azo' ),
				'return_value' => 'yes',
			)
		);

		$this->add_control(
			'rate',
			array(
				'label'        => esc_html__( 'Show Rate', 'azo' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => 'yes',
				'label_on'     => esc_html__( 'No', 'azo' ),
				'label_off'    => esc_html__( 'Yes', 'azo' ),
				'return_value' => 'yes',
			)
		);

		$this->add_control(
			'arrows',
			array(
				'label'        => esc_html__( 'Show Arrows', 'azo' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => 'yes',
				'label_on'     => esc_html__( 'No', 'azo' ),
				'label_off'    => esc_html__( 'Yes', 'azo' ),
				'return_value' => 'yes',
			)
		);

		$this->add_control(
			'dots',
			array(
				'label'        => esc_html__( 'Show Dots', 'azo' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => 'yes',
				'label_on'     => esc_html__( 'No', 'azo' ),
				'label_off'    => esc_html__( 'Yes', 'azo' ),
				'return_value' => 'yes',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'item_style',
			array(
				'label' => esc_html__( 'Item', 'azo' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'item_padding',
			array(
				'label'      => esc_html__( 'Padding', 'azo' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .testimonial-item' => 'padding:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				),
			)
		);

		$this->add_control(
			'bgcolor_item',
			array(
				'label'     => esc_html__( 'Background', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .testimonial-item' => 'background-color: {{VALUE}}',
				),
			)
		);
		$this->add_control(
			'br-item',
			array(
				'label'      => esc_html__( 'Border Radius', 'azo' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .testimonial-item' => 'border-radius:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'label'    => esc_html__( 'Box Shadow', 'azo' ),
				'name'     => 'box_shadow_item',
				'selector' => '{{WRAPPER}} .testimonial-item',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'title_style',
			array(
				'label' => esc_html__( 'Title', 'azo' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'title_color',
			array(
				'label'     => esc_html__( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#222222',
				'selectors' => array(
					'{{WRAPPER}} .tetimonial-title h3' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'title_typo',
				'selector' => '{{WRAPPER}} .tetimonial-title h3',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'star_style',
			array(
				'label' => esc_html__( 'Rate', 'azo' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'star_color',
			array(
				'label'     => esc_html__( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fdc643',
				'selectors' => array(
					'{{WRAPPER}} .testimonial--rate .fa-star:before' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'star_typo',
				'selector' => '{{WRAPPER}} .testimonial--rate',
			)
		);

		$this->add_responsive_control(
			'margin-top-rate',
			array(
				'label'     => esc_html__( 'Margin Top', 'azo' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'min' => 0,
						'max' => 1000,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .testimonial-rate' => 'margin-top: {{SIZE}}{{UNIT}}',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'content_style',
			array(
				'label' => esc_html__( 'Content', 'azo' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'content_color',
			array(
				'label'     => esc_html__( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#858585',
				'selectors' => array(
					'{{WRAPPER}} .tetimonial-content' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'content_typo',
				'selector' => '{{WRAPPER}} .tetimonial-content',
			)
		);

		$this->add_responsive_control(
			'margin-top-content',
			array(
				'label'     => esc_html__( 'Margin Top', 'azo' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'min' => 0,
						'max' => 1000,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .tetimonial-content' => 'margin-top: {{SIZE}}{{UNIT}}',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'avater_style',
			array(
				'label' => esc_html__( 'Avatar', 'azo' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'margin-top-avatar',
			array(
				'label'     => esc_html__( 'Margin Top', 'azo' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'min' => 0,
						'max' => 1000,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .testimonial-avata' => 'margin-top: {{SIZE}}{{UNIT}}',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'name_style',
			array(
				'label' => esc_html__( 'Name', 'azo' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'name_color',
			array(
				'label'     => esc_html__( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#222222',
				'selectors' => array(
					'{{WRAPPER}} .testimonial--name' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'name_typo',
				'selector' => '{{WRAPPER}} .testimonial--name',
			)
		);

		$this->add_responsive_control(
			'margin-top-name',
			array(
				'label'     => esc_html__( 'Margin Top', 'azo' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'min' => 0,
						'max' => 1000,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .testimonial-des' => 'margin-top: {{SIZE}}{{UNIT}}',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'position-name_style',
			array(
				'label' => esc_html__( 'Position Name', 'azo' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'position-name_color',
			array(
				'label'     => esc_html__( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#222222',
				'selectors' => array(
					'{{WRAPPER}} .testimonial-position-name' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'position-name_typo',
				'selector' => '{{WRAPPER}} .testimonial-position-name',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'alll_style',
			array(
				'label' => esc_html__( 'Dots', 'azo' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'dost_color',
			array(
				'label'     => esc_html__( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#222222',
				'selectors' => array(
					'{{WRAPPER}} .testimonial-slider-dots .dots-bullet:after' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .testimonial-slider-dots .slick-active .dots-bullet:after' => 'border-color: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'margin-top-dost',
			array(
				'label'     => esc_html__( 'Margin Top', 'azo' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'min' => 0,
						'max' => 1000,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .testimonial-slider-dots' => 'margin-top: {{SIZE}}{{UNIT}}',
				),
			)
		);

		$this->end_controls_section();

	}

	/**
	 * Render
	 */
	public function render() {
		$settings = $this->get_settings_for_display();
		?>
		<div class="azo-testimonial-widget layout-<?php echo esc_attr( $settings['select_layout'] ); ?>">
			<div class="testimonial-wrapper" data-show="<?php echo esc_attr( $settings['slides_to_show'] ); ?>" data-show-tablet="<?php echo esc_attr( $settings['slides_to_show_tablet'] ); ?>" data-show-mobile="<?php echo esc_attr( $settings['slides_to_show_mobile'] ); ?>" >

				<?php if ( 'yes' === $settings['arrows'] ) { ?>
					<div class="testi-arrow-widget">
						<button class="azo-arrows arrows-prev"></button>
						<button class="azo-arrows arrows-next"></button>
					</div>
				<?php } ?>

				<div class="js-testimonial testimonial-list" >
					<?php
					foreach ( $settings['testimonial'] as $testi ) {
						?>
						<div class="testimonial-item">
							<div class="tetimonial-title">
								<h3><?php echo esc_html( $testi['title'] ); ?></h3>
							</div>

							<?php if ( 'yes' === $settings['rate'] ) { ?>
								<div class="testimonial-rate">
									<span class="testimonial--rate">
										<?php
										$i    = 0;
										$star = esc_attr( $testi['rate'] );
										for ( $i; $i < $star; $i++ ) {
											$str = str_word_count( $star );
											echo wp_kses( str_replace( '0', '<span class="fa fa-star"></span> ', $str ), azo_get_allowed_html() );
										}
										?>
									</span>
								</div>
							<?php } ?>

							<div class="testimonial-order">
								<div class="tetimonial-content">
									<?php echo esc_html( $testi['content'] ); ?>
								</div>
								<?php if ( 'yes' === $settings['show_image'] ) { ?>
									<div class="testimonial-avata">
										<img src="<?php echo esc_url( $testi['testimonial_image']['url'] ); ?>" alt="<?php echo esc_attr( $testi['name'] ); ?>" class="avata-testimonial">
									</div>
								<?php } ?>

								<div class="testimonial-des">
									<span class="testimonial--name"><?php echo esc_html( $testi['name'] ); ?></span>
									<span class="testimonial-position-name"><?php echo esc_html( $testi['position-name'] ); ?></span>
								</div>
							</div>
						</div>
						<?php
					}
					?>
				</div>

				<?php if ( 'yes' === $settings['dots'] ) { ?>
					<div class="testimonial-slider-dots"></div>
				<?php } ?>
			</div>
		</div>
		<?php
	}
}
Plugin::instance()->widgets_manager->register_widget_type( new Azo_Testimonial() );

