<?php
/**
 * Azo Search brand Widget
 *
 * @package azo
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

if ( ! defined( 'WC_PLUGIN_FILE' ) ) {
	return;
}

/**
 * Class for azo elementor product images widget.
 */
class Azo_Search_Brand extends \Elementor\Widget_Base {
	/**
	 * Category
	 */
	public function get_categories() {
		return array( 'azo-theme' );
	}

	/**
	 * Name
	 */
	public function get_name() {
		return 'azo-search-brand';
	}

	/**
	 * Gets the title.
	 */
	public function get_title() {
		return __( 'Search Brand', 'azo' );
	}

	/**
	 * Gets the icon.
	 */
	public function get_icon() {
		return 'eicon-search';
	}

	/**
	 * Controls
	 */
	protected function register_controls() { //phpcs:ignore
		$this->content();
	}

	/**
	 * Content
	 */
	protected function content() {
		$this->start_controls_section(
			'style_section',
			array(
				'label' => __( 'Search', 'azo' ),
			)
		);

		$this->add_control(
			'select_layout',
			array(
				'label'   => esc_html__( 'Layout', 'azo' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'vertical_layout',
				'options' => array(
					'vertical_layout'   => esc_html__( 'Vertical', 'azo' ),
					'horizontal_layout' => esc_html__( 'Horizontal', 'azo' ),
				),
			)
		);

		$this->add_control(
			'heading',
			array(
				'label' => esc_html__( 'Heading', 'azo' ),
				'type'  => Controls_Manager::TEXT,
			)
		);

		$this->add_control(
			'input_bg',
			array(
				'label'     => esc_html__( 'Background', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#ffffff',
				'selectors' => array(
					'{{WRAPPER}} .widget-brand-search-azo .azo-search-form select, .widget-brand-search-azo input.azo-search-form__field' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'        => 'border',
				'placeholder' => '1px',
				'default'     => '1px',
				'selector'    => '{{WRAPPER}} .widget-brand-search-azo .azo-search-form select, .widget-brand-search-azo input.azo-search-form__field',
			)
		);

		$this->add_control(
			'border-radius-all',
			array(
				'label'     => esc_html__( 'Border Radius Form', 'azo' ),
				'type'      => Controls_Manager::DIMENSIONS,
				'selectors' => array(
					'{{WRAPPER}} .widget-brand-search-azo .azo-search-form select, .widget-brand-search-azo input.azo-search-form__field' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'form_height',
			array(
				'label'     => esc_html__( 'Height', 'azo' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'min' => 0,
						'max' => 1000,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .widget-brand-search-azo .azo-search-form select, .widget-brand-search-azo input.azo-search-form__field' => 'height: {{SIZE}}{{UNIT}}',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'input_section',
			array(
				'label' => __( 'Label', 'azo' ),
			)
		);

		$this->add_control(
			'input',
			array(
				'label'       => esc_html__( 'Input', 'azo' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Enter SKU', 'azo' ),
				'placeholder' => esc_attr__( 'Enter SKU', 'azo' ),
				'label_block' => true,
			)
		);

		$this->add_control(
			'input_color',
			array(
				'label'     => esc_html__( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#222222',
				'selectors' => array(
					'{{WRAPPER}} .widget-brand-search-azo .azo-search-form__field' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'input_placeholder_color',
			array(
				'label'     => esc_html__( 'Color Placeholder', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#999999',
				'selectors' => array(
					'{{WRAPPER}} .azo-search-form__field::placeholder' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'input_typography',
				'selector' => '{{WRAPPER}} .widget-brand-search-azo .azo-search-form__field',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'name-category',
			array(
				'label' => esc_html__( 'Category', 'azo' ),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'category_typography',
				'selector' => '{{WRAPPER}} .widget-brand-search-azo .azo-search-form__product-categories',
			)
		);

		$this->add_control(
			'category_color',
			array(
				'label'     => esc_html__( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .widget-brand-search-azo .azo-search-form__product-categories' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'bgcategory_color',
			array(
				'label'     => esc_html__( 'Background Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .azo-search-form__inner select' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'border-radius-category',
			array(
				'label'     => esc_html__( 'Border Radius', 'azo' ),
				'type'      => Controls_Manager::DIMENSIONS,
				'selectors' => array(
					'{{WRAPPER}} .azo-search-form__inner select' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'margin_category',
			array(
				'label'      => esc_html__( 'Margin', 'azo' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .widget-brand-search-azo .azo-search-form__product-categories' => 'margin:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				),
			)
		);

		$this->add_responsive_control(
			'padding_category',
			array(
				'label'      => esc_html__( 'Padding', 'azo' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .azo-search-form__inner select' => 'padding:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'button_section',
			array(
				'label' => __( 'Button', 'azo' ),
			)
		);

		$this->add_control(
			'button_bg_color',
			array(
				'label'     => esc_html__( 'Background Button Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#222222',
				'selectors' => array(
					'{{WRAPPER}} .search-brand-submit' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'button_bg_hover_color',
			array(
				'label'     => esc_html__( 'Background Button Hover Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#cccccc',
				'selectors' => array(
					'{{WRAPPER}} .search-brand-submit:hover' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'border-radius-submit',
			array(
				'label'     => esc_html__( 'Border Radius', 'azo' ),
				'type'      => Controls_Manager::DIMENSIONS,
				'selectors' => array(
					'{{WRAPPER}} .search-brand-submit' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'button_typography',
				'selector' => '{{WRAPPER}} .search-brand-submit',
			)
		);

		$this->add_control(
			'button_color',
			array(
				'label'     => esc_html__( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#ffffff',
				'selectors' => array(
					'{{WRAPPER}} .search-brand-submit' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'button_hover_color',
			array(
				'label'     => esc_html__( 'Color Hover', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#222222',
				'selectors' => array(
					'{{WRAPPER}} .search-brand-submit:hover' => 'color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_section();
	}

	/**
	 * Dropdown product categories
	 */
	public function azo_dropdown_product_categories() {
		if ( isset( $_GET['product_cat'] ) && ! empty( $_GET['product_cat'] ) ) { // phpcs:ignore
			$opt_select = sanitize_text_field( $_REQUEST['product_cat'] ); // phpcs:ignore
		} else {
			$opt_select = 0;
		}
		$args             = array(
			'show_option_all' => esc_html__( 'Categories', 'azo' ),
			'hierarchical'    => 1,
			'class'           => 'cat',
			'echo'            => 1,
			'value_field'     => 'slug',
			'selected'        => $opt_select,
		);
		$args['taxonomy'] = 'product_cat';
		$args['id']       = 'azo-search-form__product-categories-' . $this->get_id();
		$args['name']     = 'product_cat';
		$args['class']    = 'azo-search-form__product-categories hidden-xs';
		wp_dropdown_categories( $args );
	}

	/**
	 * Dropdown product brand
	 */
	public function azo_dropdown_product_brand() {
		if ( isset( $_GET['pwb-brand'] ) && ! empty( $_GET['pwb-brand'] ) ) { // phpcs:ignore
			$opt_select = sanitize_text_field( $_REQUEST['pwb-brand'] ); // phpcs:ignore
		} else {
			$opt_select = 0;
		}
		$args             = array(
			'show_option_all' => esc_html__( 'Brand', 'azo' ),
			'hierarchical'    => 1,
			'class'           => 'brand',
			'echo'            => 1,
			'value_field'     => 'slug',
			'selected'        => $opt_select,
		);
		$args['taxonomy'] = 'pwb-brand';
		$args['id']       = 'azo-search-form__product-brand-' . $this->get_id();
		$args['name']     = 'pwb-brand';
		$args['class']    = 'azo-search-form__product-brand hidden-xs';
		wp_dropdown_categories( $args );
	}

	/**
	 * Render
	 */
	public function render() {
		$settings = $this->get_settings_for_display();
		?>
		<div class="widget-brand-search-azo js-search-form <?php echo esc_attr( $settings['select_layout'] ); ?>">
			<div class="heading-search-brand">
				<div class="heading-brand">
					<?php
					if ( '' !== $settings['heading'] ) {
						echo esc_html( $settings['heading'] );
					} else {
						?>
						<p>
							<?php esc_html_e( 'Select your', 'azo' ); ?>
						</p>

						<h3>
							<?php esc_html_e( 'Product', 'azo' ); ?>
						</h3>
					<?php } ?>
				</div>

				<div class="colon">
					<?php esc_html_e( ':', 'azo' ); ?>
				</div>
			</div>

			<form action="<?php echo esc_url( home_url( '/' ) ); ?>" method="get" class="azo-search-form">
				<?php
				$this->azo_dropdown_product_categories();

				$this->azo_dropdown_product_brand();
				?>

				<div class="or-text">
					<?php esc_html_e( 'or', 'azo' ); ?>
				</div>

				<input type="text" name="s" class="azo-search-form__field" placeholder="<?php echo esc_attr( $settings['input'] ); ?>">					
				<input type="hidden" name="post_type" value="product">

				<button type="submit" class="search-brand-submit">
					<?php esc_html_e( 'Shop Now', 'azo' ); ?>
				</button>
			</form>
		</div>
		<?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Azo_Search_Brand() );
