<?php
/**
 * Azo Search ajax Widget
 *
 * @package azo
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

if ( ! defined( 'WC_PLUGIN_FILE' ) ) {
	return;
}

/**
 * Class for azo elementor product images widget.
 */
class Azo_Search_Ajax extends \Elementor\Widget_Base {
	/**
	 * Category
	 */
	public function get_categories() {
		return array( 'azo-theme' );
	}

	/**
	 * Name
	 */
	public function get_name() {
		return 'azo-search-ajax';
	}

	/**
	 * Gets the title.
	 */
	public function get_title() {
		return __( 'Search Ajax', 'azo' );
	}

	/**
	 * Gets the icon.
	 */
	public function get_icon() {
		return 'eicon-search';
	}

	/**
	 * Controls
	 */
	protected function register_controls() { //phpcs:ignore
		$this->content();
	}

	/**
	 * Content
	 */
	protected function content() {
		$this->start_controls_section(
			'style_section',
			array(
				'label' => __( 'Search', 'azo' ),
			)
		);

		$this->add_control(
			'select_layout',
			array(
				'label'   => esc_html__( 'Layout', 'azo' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'form_layout',
				'options' => array(
					'form_layout' => esc_html__( 'Form', 'azo' ),
					'icon_layout' => esc_html__( 'Icon', 'azo' ),
				),
			)
		);

		$this->add_control(
			'enable_product_categories',
			array(
				'label'        => esc_html__( 'Enable Product Categories', 'azo' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'Yes', 'azo' ),
				'label_off'    => __( 'No', 'azo' ),
				'return_value' => 'yes',
				'default'      => 'no',
				'condition'    => array(
					'select_layout' => 'form_layout',
				),
			)
		);

		$this->add_control(
			'input_bg',
			array(
				'label'     => esc_html__( 'Background', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#ffffff',
				'selectors' => array(
					'{{WRAPPER}} .widget-ajax-search-azo .azo-search-form' => 'background-color: {{VALUE}};',
				),
				'condition' => array(
					'select_layout' => 'form_layout',
				),
			)
		);

		$this->add_control(
			'border-radius-all',
			array(
				'label'     => esc_html__( 'Border Radius Form', 'azo' ),
				'type'      => Controls_Manager::DIMENSIONS,
				'selectors' => array(
					'{{WRAPPER}} .widget-ajax-search-azo .azo-search-form' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition' => array(
					'select_layout' => 'form_layout',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'        => 'Border-form',
				'placeholder' => '1px',
				'default'     => '1px',
				'selector'    => '{{WRAPPER}} .widget-ajax-search-azo .azo-search-form',
				'condition'   => array(
					'select_layout' => 'form_layout',
				),
			)
		);

		$this->add_control(
			'border-radius-form',
			array(
				'label'     => esc_html__( 'Border Radius', 'azo' ),
				'type'      => Controls_Manager::DIMENSIONS,
				'selectors' => array(
					'{{WRAPPER}} .widget-ajax-search-azo .azo-search-form' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'form_width',
			array(
				'label'      => __( 'Width', 'azo' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 1000,
						'step' => 5,
					),
					'%'  => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'default'    => array(
					'unit' => '%',
					'size' => 100,
				),
				'selectors'  => array(
					'{{WRAPPER}} .widget-ajax-search-azo .azo-search-form' => 'width: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'select_layout' => 'form_layout',
				),
			)
		);

		$this->add_responsive_control(
			'form_height',
			array(
				'label'     => esc_html__( 'Height', 'azo' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'min' => 0,
						'max' => 1000,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .widget-ajax-search-azo .azo-search-form' => 'height: {{SIZE}}{{UNIT}}',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'input_section',
			array(
				'label'     => __( 'Label', 'azo' ),
				'condition' => array(
					'select_layout' => 'form_layout',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'        => 'border-right',
				'placeholder' => '1px',
				'default'     => '1px',
				'selector'    => '{{WRAPPER}} .widget-ajax-search-azo .azo-search-form--horizontal input',
			)
		);

		$this->add_control(
			'input',
			array(
				'label'       => esc_html__( 'Input', 'azo' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Search entire store here...', 'azo' ),
				'placeholder' => esc_attr__( 'Search entire store here...', 'azo' ),
				'label_block' => true,
				'condition'   => array(
					'select_layout' => 'form_layout',
				),
			)
		);

		$this->add_control(
			'input_color',
			array(
				'label'     => esc_html__( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#2F2F30',
				'selectors' => array(
					'{{WRAPPER}} .widget-ajax-search-azo .azo-search-form__field' => 'color: {{VALUE}};',
				),
				'condition' => array(
					'select_layout' => 'form_layout',
				),
			)
		);

		$this->add_control(
			'input_placeholder_color',
			array(
				'label'     => esc_html__( 'Color Placeholder', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#999999',
				'selectors' => array(
					'{{WRAPPER}} .azo-search-form__field::placeholder' => 'color: {{VALUE}};',
				),
				'condition' => array(
					'select_layout' => 'form_layout',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'      => 'input_typography',
				'selector'  => '{{WRAPPER}} .widget-ajax-search-azo .azo-search-form__field',
				'condition' => array(
					'select_layout' => 'form_layout',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'name-category',
			array(
				'label'     => esc_html__( 'Category', 'azo' ),
				'condition' => array(
					'select_layout' => 'form_layout',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'category_typography',
				'selector' => '{{WRAPPER}} .widget-ajax-search-azo .azo-search-form__product-categories',
			)
		);

		$this->add_control(
			'category_color',
			array(
				'label'     => esc_html__( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .widget-ajax-search-azo .azo-search-form__product-categories' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'bgcategory_color',
			array(
				'label'     => esc_html__( 'Background Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .azo-search-form__inner select' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'border-radius-category',
			array(
				'label'     => esc_html__( 'Border Radius', 'azo' ),
				'type'      => Controls_Manager::DIMENSIONS,
				'selectors' => array(
					'{{WRAPPER}} .azo-search-form__inner select' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition' => array(
					'select_layout' => 'form_layout',
				),
			)
		);

		$this->add_responsive_control(
			'margin_category',
			array(
				'label'      => esc_html__( 'Margin', 'azo' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .widget-ajax-search-azo .azo-search-form__product-categories' => 'margin:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				),
			)
		);

		$this->add_responsive_control(
			'padding_category',
			array(
				'label'      => esc_html__( 'Padding', 'azo' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .azo-search-form__inner select' => 'padding:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'icon_section',
			array(
				'label' => __( 'Icon', 'azo' ),
			)
		);

		$this->add_control(
			'icon_align',
			array(
				'label'     => esc_html__( 'Alignment', 'azo' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'azo' ),
						'icon'  => 'fa fa-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'azo' ),
						'icon'  => 'fa fa-align-center',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'azo' ),
						'icon'  => 'fa fa-align-right',
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .widget-ajax-search-azo.azo-search-form__inner' => 'text-align:{{VALUE}}',
				),
				'default'   => 'left',
				'condition' => array(
					'select_layout' => 'icon_layout',
				),
			)
		);

		$this->add_control(
			'icon_bg_color',
			array(
				'label'     => esc_html__( 'Background Icon Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#ffb700',
				'selectors' => array(
					'{{WRAPPER}} .widget-ajax-search-azo .search-submit' => 'background-color: {{VALUE}};',
				),
				'condition' => array(
					'select_layout' => 'form_layout',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'        => 'Border-submit',
				'placeholder' => '1px',
				'default'     => '1px',
				'selector'    => '{{WRAPPER}} .widget-ajax-search-azo .search-submit',
				'condition'   => array(
					'select_layout' => 'form_layout',
				),
			)
		);

		$this->add_control(
			'border-radius-submit',
			array(
				'label'     => esc_html__( 'Border Radius', 'azo' ),
				'type'      => Controls_Manager::DIMENSIONS,
				'selectors' => array(
					'{{WRAPPER}} .widget-ajax-search-azo .search-submit' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
				'condition' => array(
					'select_layout' => 'form_layout',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'      => 'icon_typography',
				'selector'  => '{{WRAPPER}} .widget-ajax-search-azo .search-submit',
				'condition' => array(
					'select_layout' => 'form_layout',
				),
			)
		);

		$this->add_control(
			'icon_color',
			array(
				'label'     => esc_html__( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#ffffff',
				'selectors' => array(
					'{{WRAPPER}} .widget-ajax-search-azo .search-submit' => 'color: {{VALUE}};',
				),
				'condition' => array(
					'select_layout' => 'form_layout',
				),
			)
		);

		$this->add_control(
			'icon2_color',
			array(
				'label'     => esc_html__( 'Color Icon', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#ffffff',
				'selectors' => array(
					'{{WRAPPER}} .widget-ajax-search-azo .js-search-button' => 'color: {{VALUE}};',
				),
				'condition' => array(
					'select_layout' => 'icon_layout',
				),
			)
		);

		$this->add_control(
			'icon2_hover_color',
			array(
				'label'     => esc_html__( 'Color Icon Hover', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .widget-ajax-search-azo .js-search-button:hover' => 'color: {{VALUE}};',
				),
				'condition' => array(
					'select_layout' => 'icon_layout',
				),
			)
		);

		$this->add_responsive_control(
			'size',
			array(
				'label'     => __( 'Size', 'azo' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'min' => 0,
						'max' => 300,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .widget-ajax-search-azo .js-search-button:before' => 'font-size: {{SIZE}}{{UNIT}} !important;',
				),
				'condition' => array(
					'select_layout' => 'icon_layout',
				),
			)
		);

		$this->end_controls_section();
	}

	/**
	 * Dropdown product categories
	 */
	public function azo_dropdown_product_categories() {
		if ( isset( $_GET['product_cat'] ) && ! empty( $_GET['product_cat'] ) ) { // phpcs:ignore
			$opt_select = sanitize_text_field( $_REQUEST['product_cat'] ); // phpcs:ignore
		} else {
			$opt_select = 0;
		}
		$args             = array(
			'show_option_all' => esc_html__( 'All Categories', 'azo' ),
			'hierarchical'    => 1,
			'class'           => 'cat',
			'echo'            => 1,
			'value_field'     => 'slug',
			'selected'        => $opt_select,
		);
		$args['taxonomy'] = 'product_cat';
		$args['id']       = 'azo-search-form__product-categories-' . $this->get_id();
		$args['name']     = 'product_cat';
		$args['class']    = 'azo-search-form__product-categories hidden-xs';
		wp_dropdown_categories( $args );
	}

	/**
	 * Render
	 */
	public function render() {
		$settings     = $this->get_settings_for_display();
		$form_classes = 'yes' === $settings['enable_product_categories'] ? 'azo-search-form azo-search-form--horizontal' : 'azo-search-form';
		?>
		<div class="widget-ajax-search-azo azo-search-form__inner js-search-form <?php echo 'yes' === $settings['enable_product_categories'] ? 'horizontal-form' : ''; ?>">
			<?php if ( 'form_layout' === $settings['select_layout'] ) { ?>
				<form action="<?php echo esc_url( home_url( '/' ) ); ?>" method="get" class="<?php echo esc_html( $form_classes ); ?>">
					<input type="text" name="s" id="autocompletepro" class="azo-search-form__field" placeholder="<?php echo esc_attr( $settings['input'] ); ?>" autocomplete="off">					
					<input type="hidden" name="post_type" value="product">
					<span class="fa fa-circle-o-notch fa-2x fa-fw azo-search-form__loader"></span>
					<?php
					if ( 'yes' === $settings['enable_product_categories'] ) {
						$this->azo_dropdown_product_categories();
					}
					?>
					<button type="submit" class="search-submit icoros-icon_search"></button>
				</form>

				<div class="azo-search-form__suggestions"></div>
			<?php } elseif ( 'icon_layout' === $settings['select_layout'] ) { ?>
				<button class="icoros-icon_search js-search-button"></button>
			<?php } ?>
		</div>
		<?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Azo_Search_Ajax() );
