<?php
/**
 * Elementor Azo Products
 *
 * @package azo
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! defined( 'WC_PLUGIN_FILE' ) ) {
	return;
}

/**
 * Azo Widget Products
 */
class Azo_Products extends Widget_Base {

	/**
	 * Get categories
	 */
	public function get_categories() {
		return array( 'azo-theme' );
	}

	/**
	 * Get name
	 */
	public function get_name() {
		return 'products';
	}

	/**
	 * Get title
	 */
	public function get_title() {
		return esc_html__( 'Products', 'azo' );
	}

	/**
	 * Get Icon
	 */
	public function get_icon() {
		return 'eicon-products';
	}

	protected function register_controls() { //phpcs:ignore
		$this->section_general();
		$this->section_query();
		$this->section_pagination();
		$this->section_infinite_scroll();
		$this->product();
		$this->productborder();
	}

	/**
	 * Section general
	 */
	private function section_general() {
		$this->start_controls_section(
			'product_content',
			array(
				'label' => esc_html__( 'General', 'azo' ),
			)
		);

		$this->add_control(
			'layout',
			array(
				'type'    => Controls_Manager::SELECT,
				'label'   => esc_html__( 'Layout Style', 'azo' ),
				'default' => '1',
				'options' => array(
					'1' => esc_html__( 'Style 1', 'azo' ),
					'2' => esc_html__( 'Style 2', 'azo' ),
				),
			)
		);

		$this->add_control(
			'gap',
			array(
				'label'   => esc_html__( 'Gap', 'azo' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'gap-default' => esc_html__( 'Gap Default', 'azo' ),
					'gap-min'     => esc_html__( 'Gap Min', 'azo' ),
				),
				'default' => 'gap-default',
			)
		);

		$this->add_control(
			'content_text_align',
			array(
				'label'     => esc_html__( 'Alignment', 'azo' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'azo' ),
						'icon'  => 'fa fa-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'azo' ),
						'icon'  => 'fa fa-align-center',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'azo' ),
						'icon'  => 'fa fa-align-right',
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .products-layout-2 .content-info-product' => 'text-align:{{VALUE}}',
				),
				'default'   => 'left',
				'condition' => array(
					'layout' => '2',
				),
			)
		);

		$this->add_responsive_control(
			'content_info_product_spacing',
			array(
				'label'          => esc_html__( 'Spacing', 'azo' ),
				'type'           => Controls_Manager::DIMENSIONS,
				'size_units'     => array( 'px', '%', 'em' ),
				'default'        => array(
					'top'      => '1',
					'right'    => '30',
					'bottom'   => '0',
					'left'     => '30',
					'unit'     => 'px',
					'isLinked' => false,
				),
				'tablet_default' => array(
					'top'      => '0',
					'right'    => '0',
					'bottom'   => '0',
					'left'     => '0',
					'unit'     => 'px',
					'isLinked' => false,
				),
				'mobile_default' => array(
					'top'      => '0',
					'right'    => '0',
					'bottom'   => '0',
					'left'     => '0',
					'unit'     => 'px',
					'isLinked' => false,
				),
				'selectors'      => array(
					'{{WRAPPER}} .azo-pagination' => 'padding:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				),
				'selectors'      => array(
					'{{WRAPPER}} .azo-style .azo-product-cats, .azo-style .woocommerce-loop-product__title, .azo-style .price' => 'padding:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				),
				'condition'      => array(
					'layout' => '2',
				),
			)
		);

		$this->add_control(
			'stock_bar',
			array(
				'label'        => esc_html__( 'Show Stock Bar', 'azo' ),
				'type'         => Controls_Manager::SWITCHER,
				'separator'    => 'before',
				'default'      => '',
				'on'           => esc_html__( 'No', 'azo' ),
				'off'          => esc_html__( 'Yes', 'azo' ),
				'return_value' => 'yes',
			)
		);

		// Color.
		$this->add_control(
			'bg_stockbar_color',
			array(
				'label'     => __( 'Color Stock Bar', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .loop-product-stock .sold-bar' => 'background-color: {{VALUE}};',
				),
				'condition' => array(
					'stock_bar' => 'yes',
				),
			)
		);

		$this->add_control(
			'rate',
			array(
				'label'   => esc_html__( 'Rate display', 'azo' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'default' => esc_html__( 'Default', 'azo' ),
					'no-rate' => esc_html__( 'No rate', 'azo' ),
				),
				'default' => 'default',
			)
		);

		$this->add_control(
			'col',
			array(
				'type'    => Controls_Manager::SELECT,
				'label'   => esc_html__( 'Columns', 'azo' ),
				'default' => 4,
				'options' => array(
					1 => 1,
					2 => 2,
					3 => 3,
					4 => 4,
					5 => 5,
					6 => 6,
				),
			)
		);

		$this->add_control(
			'navigation',
			array(
				'type'    => Controls_Manager::SELECT,
				'label'   => esc_html__( 'Navigation', 'azo' ),
				'default' => 'none',
				'options' => array(
					'none'       => esc_html__( 'None', 'azo' ),
					'pagination' => esc_html__( 'Pagination', 'azo' ),
					'scroll'     => esc_html__( 'Infinite Scroll', 'azo' ),
				),
			)
		);

		$this->end_controls_section();
	}

	/**
	 * Section query
	 */
	private function section_query() {
		$this->start_controls_section(
			'product_query',
			array(
				'label' => esc_html__( 'Query', 'azo' ),
			)
		);

		$this->add_control(
			'cat_ids',
			array(
				'label' => esc_html__( 'Categories', 'azo' ),
				'type'  => 'autocomplete',
				'query' => array(
					'type' => 'term',
					'name' => 'product_cat',
				),
			)
		);

		$this->add_control(
			'product_ids',
			array(
				'label' => esc_html__( 'Products', 'azo' ),
				'type'  => 'autocomplete',
				'query' => array(
					'type' => 'post_type',
					'name' => 'product',
				),
			)
		);

		$this->add_control(
			'ex_cat_ids',
			array(
				'label' => esc_html__( 'Exclude Categories', 'azo' ),
				'type'  => 'autocomplete',
				'query' => array(
					'type' => 'term',
					'name' => 'product_cat',
				),
			)
		);

		$this->add_control(
			'ex_product_ids',
			array(
				'label' => esc_html__( 'Exclude Products', 'azo' ),
				'type'  => 'autocomplete',
				'query' => array(
					'type' => 'post_type',
					'name' => 'product',
				),
			)
		);

		$this->add_control(
			'count',
			array(
				'label'   => esc_html__( 'Posts Per Page', 'azo' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 6,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			)
		);

		$this->add_control(
			'order_by',
			array(
				'label'   => esc_html__( 'Order By', 'azo' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'id',
				'options' => array(
					'id'   => esc_html__( 'ID', 'azo' ),
					'name' => esc_html__( 'Name', 'azo' ),
					'date' => esc_html__( 'Date', 'azo' ),
					'rand' => esc_html__( 'Random', 'azo' ),
				),
			)
		);

		$this->add_control(
			'order',
			array(
				'label'   => esc_html__( 'Order', 'azo' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'ASC',
				'options' => array(
					'ASC'  => esc_html__( 'ASC', 'azo' ),
					'DESC' => esc_html__( 'DESC', 'azo' ),
				),
			)
		);

		$this->end_controls_section();
	}

	/**
	 * Pagination
	 */
	private function section_pagination() {
		$this->start_controls_section(
			'pagination_section',
			array(
				'label'     => esc_html__( 'Pagination', 'azo' ),
				'condition' => array(
					'navigation' => 'pagination',
				),
			)
		);

		$this->add_responsive_control(
			'pagi_position',
			array(
				'type'           => Controls_Manager::CHOOSE,
				'label'          => esc_html__( 'Alignment', 'azo' ),
				'options'        => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'azo' ),
						'icon'  => 'fa fa-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'azo' ),
						'icon'  => 'fa fa-align-center',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'azo' ),
						'icon'  => 'fa fa-align-right',
					),
				),
				'default'        => 'center',
				'tablet_default' => 'center',
				'mobile_default' => 'center',
				'selectors'      => array(
					'{{WRAPPER}} .ht-pagination' => 'text-align: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'pagi_space',
			array(
				'type'           => Controls_Manager::DIMENSIONS,
				'label'          => esc_html__( 'Space', 'azo' ),
				'size_units'     => array( 'px', 'em' ),
				'default'        => array(
					'top'      => '30',
					'right'    => '0',
					'bottom'   => '0',
					'left'     => '0',
					'unit'     => 'px',
					'isLinked' => false,
				),
				'tablet_default' => array(
					'top'      => '20',
					'right'    => '0',
					'bottom'   => '20',
					'left'     => '0',
					'unit'     => 'px',
					'isLinked' => false,
				),
				'mobile_default' => array(
					'top'      => '15',
					'right'    => '0',
					'bottom'   => '15',
					'left'     => '0',
					'unit'     => 'px',
					'isLinked' => false,
				),
				'selectors'      => array(
					'{{WRAPPER}} .ht-pagination' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
	}

	/**
	 * Product
	 */
	private function product() {

		$this->start_controls_section(
			'product',
			array(
				'label' => __( 'Product', 'azo' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'product_title',
			array(
				'label' => __( 'Title', 'azo' ),
				'type'  => Controls_Manager::HEADING,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'product_style_title_typo',
				'label'    => esc_html__( 'Typography', 'azo' ),
				'selector' => '{{WRAPPER}} .woocommerce-loop-product__title',
			)
		);

		// Title Spacing.
		$this->add_responsive_control(
			'title_spacing',
			array(
				'label'           => __( 'Spacing', 'azo' ),
				'type'            => Controls_Manager::SLIDER,
				'range'           => array(
					'px' => array(
						'max' => 200,
					),
				),
				'devices'         => array(
					'desktop',
					'tablet',
					'mobile',
				),
				'desktop_default' => array(
					'size' => 0,
					'unit' => 'px',
				),
				'tablet_default'  => array(
					'size' => 0,
					'unit' => 'px',
				),
				'mobile_default'  => array(
					'size' => 0,
					'unit' => 'px',
				),
				'selectors'       => array(
					'{{WRAPPER}} .woocommerce-loop-product__title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				),
			)
		);

		// TAB START.
		$this->start_controls_tabs( 'product_style_tabs' );

		// Normal.
		$this->start_controls_tab(
			'product_style_normal',
			array(
				'label' => __( 'Normal', 'azo' ),
			)
		);

		// Color.
		$this->add_control(
			'product_style_title_color',
			array(
				'label'     => __( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .woocommerce-loop-product__title' => 'color: {{VALUE}};',
				),
			)
		);

		// END NORMAL.
		$this->end_controls_tab();

		// HOVER.
		$this->start_controls_tab(
			'product_style_hover',
			array(
				'label' => __( 'Hover', 'azo' ),
			)
		);

		// Hover color.
		$this->add_control(
			'product_style_color',
			array(
				'label'     => __( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} a:hover .woocommerce-loop-product__title' => 'color: {{VALUE}};',
				),
			)
		);

		// TAB END.
		$this->end_controls_tab();
		$this->end_controls_tabs();

		// Price.
		$this->add_control(
			'product_price',
			array(
				'label'     => __( 'Price', 'azo' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		// Color Price.
		$this->add_control(
			'product_price_color',
			array(
				'label'     => __( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .price ins span, {{WRAPPER}} .price span' => 'color: {{VALUE}};',
				),
			)
		);

		// Price Typography.
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'product_price_typo',
				'label'    => esc_html__( 'Typography', 'azo' ),
				'selector' => '{{WRAPPER}} .price ins span, {{WRAPPER}} .price span',
			)
		);

		// Regular Price.
		$this->add_control(
			'product_regular_price',
			array(
				'label'     => __( 'Sale Price', 'azo' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		// Color Regular Price.
		$this->add_control(
			'product_regular_price_color',
			array(
				'label'     => __( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .price del span, {{WRAPPER}} .price del' => 'color: {{VALUE}};',
				),
			)
		);

		// Regular Price Typography.
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'product_regular_price_typo',
				'label'    => esc_html__( 'Typography', 'azo' ),
				'selector' => '{{WRAPPER}} .price del span',
			)
		);

		// Style Button.
		$this->add_control(
			'product_button',
			array(
				'label'     => __( 'Button', 'azo' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		// Button Typography.
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'product_button_typo',
				'label'    => esc_html__( 'Typography', 'azo' ),
				'selector' => '{{WRAPPER}} .azo-add-to-cart-btn',
			)
		);

		// TAB START.
		$this->start_controls_tabs( 'atcbutton_style_tabs' );

		// Normal.
		$this->start_controls_tab(
			'atcbutton_style_normal',
			array(
				'label' => __( 'Normal', 'azo' ),
			)
		);

		// Color Button.
		$this->add_control(
			'atcbutton_button_color',
			array(
				'label'     => __( 'Color Button', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .azo-add-to-cart-btn' => 'color: {{VALUE}};',
				),
			)
		);

		// Background Color Button.
		$this->add_control(
			'atcbutton_button_bg_color',
			array(
				'label'     => __( 'Background Color Button', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .azo-add-to-cart-btn' => 'background-color: {{VALUE}};',
				),
			)
		);

		// END NORMAL.
		$this->end_controls_tab();

		// HOVER.
		$this->start_controls_tab(
			'atcbutton_style_hover',
			array(
				'label' => __( 'Hover', 'azo' ),
			)
		);

		// Color Hover Button.
		$this->add_control(
			'atcbutton_button_hover_color',
			array(
				'label'     => __( 'Color Hover Button', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .azo-add-to-cart-btn:hover' => 'color: {{VALUE}};',
				),
			)
		);

		// Background Color Button.
		$this->add_control(
			'atcbutton_button_bg_hover_color',
			array(
				'label'     => __( 'Background Hover Color Button', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .azo-add-to-cart-btn:hover' => 'background-color: {{VALUE}};',
				),
			)
		);

		// TAB END.
		$this->end_controls_tab();
		$this->end_controls_tabs();

		// Style Rate.
		$this->add_control(
			'product_rate',
			array(
				'label'     => __( 'Rate', 'azo' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		// Color Rate.
		$this->add_control(
			'product_rate_color',
			array(
				'label'     => __( 'Color Rate', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .star-rating > span:before' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'product_thumbnail',
			array(
				'label'     => __( 'Thumbnail', 'azo' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		// Height Image.
		$this->add_responsive_control(
			'thumbnail_height',
			array(
				'label'     => __( 'Height Image', 'azo' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'max' => 900,
					),
				),
				'devices'   => array(
					'desktop',
					'tablet',
					'mobile',
				),
				'selectors' => array(
					'{{WRAPPER}} .products .product-image-wrapper a img' => 'height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		// Width Image.
		$this->add_responsive_control(
			'thumbnail_width',
			array(
				'label'     => __( 'Width Image', 'azo' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'%' => array(
						'max' => 100,
					),
				),
				'devices'   => array(
					'desktop',
					'tablet',
					'mobile',
				),
				'selectors' => array(
					'{{WRAPPER}} .products-layout-2 .product-image-wrapper' => 'width: {{SIZE}}{{UNIT}};',
				),
				'condition' => array(
					'layout' => '2',
				),
			)
		);

		$this->add_control(
			'info_bg_color',
			array(
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Background Color', 'azo' ),
				'default'   => '#ffffff',
				'selectors' => array(
					'{{WRAPPER}} .content-info-product' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_section();
	}

	/**
	 * Product
	 */
	private function productborder() {
		$this->start_controls_section(
			'productborder',
			array(
				'label'     => __( 'Product Border', 'azo' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'layout' => '2',
				),
			)
		);

		// Image Option.
		$this->add_control(
			'product_image',
			array(
				'label' => __( 'Image', 'azo' ),
				'type'  => Controls_Manager::HEADING,
			)
		);

		// Border.
		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'border-image',
				'label'    => __( 'Border Image', 'azo' ),
				'selector' => '{{WRAPPER}} .products-layout-2 .product-image-wrapper',
			)
		);

		$this->add_control(
			'border_radius_image',
			array(
				'label'      => __( 'Border Radius', 'azo' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px' ),
				'selectors'  => array(
					'{{WRAPPER}} .products-layout-2 .product-image-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		// Space Container Option.
		$this->add_control(
			'product_space_container',
			array(
				'label'     => __( 'Space', 'azo' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		// Product Spacing.
		$this->add_responsive_control(
			'product_spacing',
			array(
				'label'           => __( 'Spacing', 'azo' ),
				'type'            => Controls_Manager::SLIDER,
				'range'           => array(
					'px' => array(
						'max' => 200,
					),
				),
				'devices'         => array(
					'desktop',
					'tablet',
					'mobile',
				),
				'desktop_default' => array(
					'size' => 23,
					'unit' => 'px',
				),
				'tablet_default'  => array(
					'size' => 0,
					'unit' => 'px',
				),
				'mobile_default'  => array(
					'size' => 0,
					'unit' => 'px',
				),
				'selectors'       => array(
					'{{WRAPPER}} .products-layout-2 .products.columns-1 .product' => 'padding-bottom: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'margin_content',
			array(
				'label'      => esc_html__( 'Margin Content', 'azo' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .products .product' => 'margin:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				),
			)
		);

		$this->add_responsive_control(
			'Padding_content',
			array(
				'label'      => esc_html__( 'Padding Content', 'azo' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .products-layout-2 .products.columns-1 .product' => 'padding:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				),
			)
		);

		// Space Info Option.
		$this->add_control(
			'product_space_info',
			array(
				'label'     => __( 'Space Info', 'azo' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		// Space info.
		$this->add_responsive_control(
			'margin_info',
			array(
				'label'      => esc_html__( 'Margin Info', 'azo' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .content-info-product' => 'margin:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				),
			)
		);

		// Space info.
		$this->add_responsive_control(
			'padding_info',
			array(
				'label'      => esc_html__( 'Padding Info', 'azo' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .content-info-product' => 'padding:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				),
			)
		);

		$this->end_controls_section();
	}

	/**
	 * Infinite scroll
	 */
	private function section_infinite_scroll() {
		$this->start_controls_section(
			'infinite_scroll_section',
			array(
				'label'     => esc_html__( 'Load More Button', 'azo' ),
				'condition' => array(
					'navigation' => 'scroll',
				),
			)
		);

		$this->add_control(
			'button_bg_color',
			array(
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Background Color', 'azo' ),
				'default'   => '#222',
				'selectors' => array(
					'{{WRAPPER}} .load-more-product-btn' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'button_position',
			array(
				'type'           => Controls_Manager::CHOOSE,
				'label'          => esc_html__( 'Alignment', 'azo' ),
				'options'        => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'azo' ),
						'icon'  => 'fa fa-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'azo' ),
						'icon'  => 'fa fa-align-center',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'azo' ),
						'icon'  => 'fa fa-align-right',
					),
				),
				'default'        => 'center',
				'tablet_default' => 'center',
				'mobile_default' => 'center',
				'selectors'      => array(
					'{{WRAPPER}} .ht-pagination' => 'text-align: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'button_padding',
			array(
				'type'       => Controls_Manager::DIMENSIONS,
				'label'      => esc_html__( 'Padding', 'azo' ),
				'size_units' => array( 'px', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .load-more-product-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'button_space',
			array(
				'type'           => Controls_Manager::DIMENSIONS,
				'label'          => esc_html__( 'Space', 'azo' ),
				'size_units'     => array( 'px', 'em' ),
				'default'        => array(
					'top'      => '30',
					'right'    => '0',
					'bottom'   => '0',
					'left'     => '0',
					'unit'     => 'px',
					'isLinked' => false,
				),
				'tablet_default' => array(
					'top'      => '20',
					'right'    => '0',
					'bottom'   => '20',
					'left'     => '0',
					'unit'     => 'px',
					'isLinked' => false,
				),
				'mobile_default' => array(
					'top'      => '15',
					'right'    => '0',
					'bottom'   => '15',
					'left'     => '0',
					'unit'     => 'px',
					'isLinked' => false,
				),
				'selectors'      => array(
					'{{WRAPPER}} .ht-pagination' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
	}

	/**
	 * Render
	 */
	protected function render() {
		$settings   = $this->get_settings_for_display();
		$layout     = $settings['layout'];
		$style_gap  = $settings['gap'];
		$style_rate = $settings['rate'];

		$paged = is_front_page() ? get_query_var( 'page' ) : get_query_var( 'paged' );
		$paged = $paged ? $paged : 1;
		$args  = array(
			'post_type'      => 'product',
			'post_status'    => 'publish',
			'posts_per_page' => $settings['count'],
			'orderby'        => $settings['order_by'],
			'order'          => $settings['order'],
			'paged'          => $paged,
		);

		// Category ids.
		$cat_ids    = $settings['cat_ids'];
		$ex_cat_ids = $settings['ex_cat_ids'];

		// Product ids.
		$product_ids    = $settings['product_ids'];
		$ex_product_ids = $settings['ex_product_ids'];

		if ( ! empty( $cat_ids ) ) {
			$args['tax_query'] = array( //phpcs:ignore
				array(
					'taxonomy' => 'product_cat',
					'field'    => 'term_id',
					'operator' => 'IN',
					'terms'    => $cat_ids,
				),
			);
		}

		if ( ! empty( $product_ids ) ) {
			$args['post__in'] = $product_ids;
		}

		if ( ! empty( $ex_product_ids ) ) {
			$args['post__not_in'] = $ex_product_ids;
		}

		$products_query = new \WP_Query( $args );
		$total          = $products_query->post_count;
		if ( ! $products_query->have_posts() ) {
			return;
		}

		if ( '' === $settings['stock_bar'] ) {
			remove_action( 'woocommerce_shop_loop_item_title', 'azo_product_stock_bar', 10 );
		} else {
			add_action( 'woocommerce_shop_loop_item_title', 'azo_product_stock_bar', 10 );
		}
		?>
		<div class="azo-widget-products products-layout-<?php echo esc_attr( $layout ); ?> <?php echo esc_attr( $style_gap ); ?> <?php echo esc_attr( $style_rate ); ?>">
			<?php
			global $woocommerce_loop;

			$woocommerce_loop['columns'] = (int) $settings['col'];

			woocommerce_product_loop_start();

			while ( $products_query->have_posts() ) :
				$products_query->the_post();
				get_template_part( 'template-parts/content', 'listproduct' );
			endwhile;

			woocommerce_product_loop_end();

			woocommerce_reset_loop();

			if ( 'pagination' === $settings['navigation'] ) {
				$total   = intval( $products_query->max_num_pages );
				$current = max( 1, $paged );
				$base    = esc_url_raw( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) );
				$format  = '?product-page=%#%';
				?>
					<nav class="ht-pagination">
					<?php
					echo paginate_links( //phpcs:ignore
						apply_filters(
							'azo_product_pagination',
							array(
								'base'      => $base,
								'format'    => '',
								'add_args'  => false,
								'current'   => max( 1, $current ),
								'total'     => $total,
								'prev_text' => '&larr;',
								'next_text' => '&rarr;',
								'type'      => 'list',
								'mid_size'  => 1,
							)
						)
					);
					?>
					</nav>
				<?php
			} elseif ( 'scroll' === $settings['navigation'] ) {
				azo_get_next_shop_page( true, $total );
			}

			wp_reset_postdata();
			?>
		</div>
		<?php
	}
}
Plugin::instance()->widgets_manager->register_widget_type( new Azo_Products() );
