<?php
/**
 * Azo Login Widget
 *
 * @package azo
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

if ( ! defined( 'WC_PLUGIN_FILE' ) ) {
	return;
}

/**
 * Class for azo elementor product images widget.
 */
class Azo_Login extends \Elementor\Widget_Base {
	/**
	 * Category
	 */
	public function get_categories() {
		return array( 'azo-theme' );
	}

	/**
	 * Name
	 */
	public function get_name() {
		return 'azo-login';
	}

	/**
	 * Gets the title.
	 */
	public function get_title() {
		return __( 'Azo Login', 'azo' );
	}

	/**
	 * Gets the icon.
	 */
	public function get_icon() {
		return 'eicon-user-circle-o';
	}

	/** SCRIPTS. */
	public function get_script_depends() {
		return array( 'azo-login' );
	}

	/**
	 * Controls
	 */
	protected function _register_controls() { //phpcs:ignore

		$this->start_controls_section(
			'section_login',
			array(
				'label' => esc_html__( 'Login', 'azo' ),
			)
		);

		$this->add_control(
			'layout',
			array(
				'label'   => esc_html__( 'Layout', 'azo' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'slidebar' => 'Slidebar',
					'popup'    => 'Popup',
				),
				'default' => 'slidebar',
			)
		);

		$this->add_control(
			'button_type',
			array(
				'label'   => esc_html__( 'Button Type', 'azo' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'icon' => 'Icon',
					'text' => 'Text',
				),
				'default' => 'icon',
			)
		);

		$this->add_control(
			'icon_login',
			array(
				'label'            => esc_html__( 'Icon', 'azo' ),
				'type'             => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default'          => array(
					'value'   => 'far fa-user',
					'library' => 'fa-solid',
				),
				'skin'             => 'inline',
				'condition'        => array(
					'button_type' => 'icon',
				),

			)
		);

		$this->add_control(
			'text_login',
			array(
				'label'       => esc_html__( 'Label', 'azo' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter Label', 'azo' ),
				'default'     => esc_html__( 'Log In or Create an Account', 'azo' ),
				'label_block' => true,
				'condition'   => array(
					'button_type' => 'text',
				),
			)
		);

		$this->add_control(
			'button_align',
			array(
				'label'     => esc_html__( 'Alignment button', 'azo' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'azo' ),
						'icon'  => 'fa fa-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'azo' ),
						'icon'  => 'fa fa-align-center',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'azo' ),
						'icon'  => 'fa fa-align-right',
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .login' => 'text-align:{{VALUE}}',
					'{{WRAPPER}} .author-info .info-author' => 'text-align:{{VALUE}}',
				),
				'default'   => 'left',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'button_style',
			array(
				'label' => esc_html__( 'Button', 'azo' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'icon_typo',
			array(
				'label'     => esc_html__( 'Size icon', 'azo' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'min' => 1,
						'max' => 300,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .profile-azo'         => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .js-call-popup-login' => 'font-size: {{SIZE}}{{UNIT}};',
				),
				'separator' => 'before',
				'condition' => array(
					'button_type' => 'icon',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'      => 'button_text_typo',
				'label'     => esc_html__( 'Typography', 'azo' ),
				'selector'  => '{{WRAPPER}} .text-login',
				'condition' => array(
					'button_type' => 'text',
				),
			)
		);

		$this->add_control(
			'button_login_color',
			array(
				'label'     => esc_html__( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .button-icon-svg svg' => 'fill: {{VALUE}}',
					'{{WRAPPER}} .button-icon'         => 'color: {{VALUE}}',
					'{{WRAPPER}} .text-login'          => 'color: {{VALUE}}',
					'{{WRAPPER}} .author-info a'       => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'button_login_color:hover',
			array(
				'label'     => esc_html__( 'Hover Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .button-icon-svg:hover svg' => 'fill: {{VALUE}}',
					'{{WRAPPER}} .button-icon:hover'   => 'color: {{VALUE}}',
					'{{WRAPPER}} .text-login:hover'    => 'color: {{VALUE}}',
					'{{WRAPPER}} .author-info a:hover' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'margin_icon',
			array(
				'label'      => esc_html__( 'Margin', 'azo' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .login' => 'margin:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'content_poup_login',
			array(
				'label' => esc_html__( 'Content Popup', 'azo' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'top_popup',
			array(
				'label'     => esc_html__( 'Top popup', 'azo' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'title-top-popup',
				'label'    => esc_html__( 'Title', 'azo' ),
				'selector' => '{{WRAPPER}} .login-azo-widget .popup-login .widget-heading .widget-title',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'title-top-close',
				'label'    => esc_html__( 'Title close', 'azo' ),
				'selector' => '{{WRAPPER}} .close-side-widget a',
			)
		);

		$this->add_control(
			'color_title',
			array(
				'label'     => esc_html__( 'Color Title', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .widget-heading .widget-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .close-side-widget a' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'color_title_hover',
			array(
				'label'     => esc_html__( 'Color Title hover', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .close-side-widget a:hover' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'center_popup',
			array(
				'label'     => __( 'Form popup', 'azo' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'label-mail-popup',
				'label'    => esc_html__( 'Label Email', 'azo' ),
				'selector' => '{{WRAPPER}} .popup-login .login-username label',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'label-pass-popup',
				'label'    => esc_html__( 'Label Pass', 'azo' ),
				'selector' => '{{WRAPPER}} .popup-login .login-password label',
			)
		);

		$this->add_control(
			'color_title_center_popup',
			array(
				'label'     => esc_html__( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .popup-login .login-username label' => 'color: {{VALUE}}',
					'{{WRAPPER}} .popup-login .login-password label' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'label-remember-popup',
				'label'    => esc_html__( 'Label Remember', 'azo' ),
				'selector' => '{{WRAPPER}} .popup-login .login-remember label',
			)
		);

		$this->add_control(
			'color_label_remember',
			array(
				'label'     => esc_html__( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .popup-login .login-remember label' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'label-lost-pass-popup',
				'label'    => esc_html__( 'Label Lost Pass', 'azo' ),
				'selector' => '{{WRAPPER}} .popup-login .lost-password',
			)
		);

		$this->add_control(
			'color_label_lost_pass',
			array(
				'label'     => esc_html__( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .popup-login .lost-password' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'color_label_lost_pass_hover',
			array(
				'label'     => esc_html__( 'Color hover', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .popup-login .lost-password:hover' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'submit-popup',
				'label'    => esc_html__( 'Submit', 'azo' ),
				'selector' => '{{WRAPPER}} .content-login form .login-submit input',
			)
		);

		$this->add_control(
			'color_submit',
			array(
				'label'     => esc_html__( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .content-login form .login-submit input' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'color_submit_hover',
			array(
				'label'     => esc_html__( 'Color Hover', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .content-login form .login-submit input:hover' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'bgcolor_submit',
			array(
				'label'     => esc_html__( 'Background Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .content-login form .login-submit input' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'bgcolor_submit_hover',
			array(
				'label'     => esc_html__( 'Background Color Hover', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .content-login form .login-submit input:hover' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'bottom_popup',
			array(
				'label'     => esc_html__( 'Bottom popup', 'azo' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'question-popup',
				'label'    => esc_html__( 'Question', 'azo' ),
				'selector' => '{{WRAPPER}} .create-account-question p',
			)
		);

		$this->add_control(
			'color-question-popup',
			array(
				'label'     => esc_html__( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .create-account-question p' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'create-account',
				'label'    => esc_html__( 'Create Account', 'azo' ),
				'selector' => '{{WRAPPER}} .create-account-question a',
			)
		);

		$this->add_control(
			'color-create-account',
			array(
				'label'     => esc_html__( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .create-account-question a' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'color-bottom-create-account',
			array(
				'label'     => esc_html__( 'Color border bottom', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .create-account-question a' => 'border-bottom: 2px solid {{VALUE}}',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'style_popup_width',
			array(
				'label'     => esc_html__( 'Width, Height Popup', 'azo' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'layout' => 'popup',
				),
			)
		);

		$this->add_responsive_control(
			'width_popup',
			array(
				'label'     => esc_html__( 'Width', 'azo' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'min' => 1,
						'max' => 1000,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .login-azo-widget.login-layout-popup .popup-login' => 'width: {{SIZE}}{{UNIT}}; height:auto;',
				),
			)
		);

		$this->add_responsive_control(
			'height_popup',
			array(
				'label'     => esc_html__( 'Height', 'azo' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'min' => 1,
						'max' => 1000,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .login-azo-widget.login-layout-popup .popup-login' => 'height: {{SIZE}}{{UNIT}}; height:auto;',
				),
			)
		);

		$this->end_controls_section();
	}

	/**
	 * Render
	 */
	public function render() {
		$settings    = $this->get_settings_for_display();
		$button_icon = $settings['icon_login'];
		$button_text = $settings['text_login'];
		if ( empty( $button_text ) ) {
			$button_text = null;
		}

		?>
		<div class="login-azo-widget login-layout-<?php echo esc_attr( $settings['layout'] ); ?>">

			<?php if ( is_user_logged_in() ) { ?>
				<div class="author-info">
					<div class="info-author">
						<a href="<?php echo esc_url( home_url( '/my-account/' ) ); ?>" class="profile-azo">
							<?php azo_get_svg( 'user' ); ?>
						</a>
					</div>
				</div>
			<?php } else { ?>
				<div class="login">
					<?php if ( 'icon' === $settings['button_type'] ) { ?>
						<a href="#" class="js-call-popup-login">
							<span class="button-align">
								<?php
								if ( ! empty( $button_icon['value'] ) ) {
									if ( is_string( $button_icon['value'] ) ) {
										azo_get_svg( 'user' );
									} else {
										?>
										<span class="button-icon button-icon-svg">
											<?php Icons_Manager::render_icon( $button_icon, '' ); ?>
										</span>
										<?php
									}
								}
								?>
							</span>
						</a>
					<?php } else { ?>
						<a href="javascript:void(0)" class="js-call-popup-login text-login">
							<?php echo wp_kses( $button_text, azo_get_allowed_html() ); ?>
						</a> 
					<?php } ?>
				</div>
			<?php } ?>
			<div class="popup-login js-poup-login">
				<div class="widget-heading">
					<h4 class="widget-title"><?php echo esc_html__( 'Sign in', 'azo' ); ?></h4>
					<div class="close-side-widget">
						<a href="javascript:void(0)" class="close-popup-login js-close-popup-login">
							<i class="icoros-icon_Close"></i>
						</a>
					</div>
				</div>
				<div class="content-login">
					<?php wp_login_form(); ?>
				</div>
				<div class="create-account-question">
					<p><?php echo esc_html__( 'No account yet?', 'azo' ); ?></p>
					<a href="<?php echo esc_url( home_url( '/my-account' ) ); ?>"><?php echo esc_html__( 'Create an Account', 'azo' ); ?></a>
				</div>

			</div>
			<div class="bg-popup-login js-bg-popup-login"></div>
		</div>
		<?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Azo_Login() );
