<?php
/**
 * Elementor Images Slider Widget
 *
 * @package azo
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class for azo elementor Images SLider widget.
 */
class Azo_Images_Slider extends \Elementor\Widget_Base {
	/**
	 * Category
	 */
	public function get_categories() {
		return array( 'azo-theme' );
	}

	/**
	 * Name
	 */
	public function get_name() {
		return 'azo-images-slider';
	}

	/**
	 * Gets the title.
	 */
	public function get_title() {
		return __( 'Images Slider', 'azo' );
	}

	/**
	 * Gets the icon.
	 */
	public function get_icon() {
		return 'eicon-carousel';
	}

	/**
	 * Retrieve the list of scripts the widget depended on
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return array( 'azo-images-slider' );
	}

	/**
	 * Controls
	 */
	protected function register_controls() { //phpcs:ignore

		$this->start_controls_section(
			'section_images',
			array(
				'label' => esc_html__( 'Images Slider', 'azo' ),
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'images_image',
			array(
				'label'   => esc_html__( 'Add Image', 'azo' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),
			)
		);

		$repeater->add_control(
			'name',
			array(
				'label'       => esc_html__( 'Title', 'azo' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter Title', 'azo' ),
				'default'     => esc_html__( 'Stoptech', 'azo' ),
			)
		);

		$repeater->add_control(
			'content',
			array(
				'label'       => esc_html__( 'Description', 'azo' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter Description', 'azo' ),
				'default'     => esc_html__( 'Description For Product', 'azo' ),
			)
		);

		$repeater->add_control(
			'link',
			array(
				'label'       => esc_html__( 'Link to', 'azo' ),
				'type'        => Controls_Manager::URL,
				'dynamic'     => array(
					'active' => true,
				),
				'placeholder' => esc_html__( 'https://your-link.com', 'azo' ),
			)
		);

		$this->add_control(
			'images',
			array(
				'label'       => esc_html__( 'images', 'azo' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ name }}}',
				'default'     => array(
					array(),
					array(),
					array(),
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_layout',
			array(
				'label' => esc_html__( 'Layout', 'azo' ),
			)
		);

		$this->add_control(
			'title',
			array(
				'label'   => __( 'Title', 'azo' ),
				'type'    => Controls_Manager::TEXT,
				'default' => 'Title Image Slider',
			)
		);

		$this->add_responsive_control(
			'section_position',
			array(
				'type'           => Controls_Manager::CHOOSE,
				'label'          => esc_html__( 'Alignment', 'azo' ),
				'options'        => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'azo' ),
						'icon'  => 'fa fa-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'azo' ),
						'icon'  => 'fa fa-align-center',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'azo' ),
						'icon'  => 'fa fa-align-right',
					),
				),
				'default'        => 'center',
				'tablet_default' => 'center',
				'mobile_default' => 'center',
				'selectors'      => array(
					'{{WRAPPER}} .images-order' => 'text-align: {{VALUE}};',
				),
			)
		);

		// Slides to show.
		$this->add_responsive_control(
			'slides_to_show',
			array(
				'label'                 => esc_html__( 'Slides to show', 'azo' ),
				'type'                  => Controls_Manager::NUMBER,
				'min'                   => 1,
				'max'                   => 5,
				'step'                  => 1,
				'devices'               => array( 'desktop', 'tablet', 'mobile' ),
				'slides_to_show_mobile' => array( 'default' => 1 ),
				'slides_to_show_tablet' => array( 'default' => 2 ),
				'slides_to_show'        => array( 'default' => 3 ),
			)
		);

		$this->add_responsive_control(
			'date_padding',
			array(
				'label'      => esc_html__( 'Padding', 'azo' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .azo-images-widget .js-images-slider .images-item .images-slider .slider-images' => 'max-width:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				),
				'condition'  => array(
					'date' => 'yes',
				),
			)
		);

		$this->add_responsive_control(
			'space',
			array(
				'label'          => __( 'Max Width', 'azo' ) . ' (px)',
				'type'           => Controls_Manager::SLIDER,
				'default'        => array(
					'unit' => 'px',
				),
				'tablet_default' => array(
					'unit' => 'px',
				),
				'mobile_default' => array(
					'unit' => 'px',
				),
				'size_units'     => array( 'px' ),
				'range'          => array(
					'px' => array(
						'min' => 150,
						'max' => 300,
					),
				),
				'selectors'      => array(
					'{{WRAPPER}} .azo-images-widget .js-images-slider .images-item .images-slider .slider-images' => 'max-width: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'arrows',
			array(
				'label'        => esc_html__( 'Show Arrows', 'azo' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => 'yes',
				'label_on'     => esc_html__( 'No', 'azo' ),
				'label_off'    => esc_html__( 'Yes', 'azo' ),
				'return_value' => 'yes',
			)
		);

		$this->add_control(
			'description',
			array(
				'label'        => esc_html__( 'Show Description', 'azo' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => 'no',
				'label_on'     => esc_html__( 'No', 'azo' ),
				'label_off'    => esc_html__( 'Yes', 'azo' ),
				'return_value' => 'yes',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'title_style',
			array(
				'label' => esc_html__( 'Title', 'azo' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'title_color',
			array(
				'label'     => esc_html__( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#333333',
				'selectors' => array(
					'{{WRAPPER}} .title-images' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'title_typo',
				'selector' => '{{WRAPPER}} .title-images',
			)
		);

		$this->add_control(
			'bg_title_color',
			array(
				'label'     => esc_html__( 'Background Title Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#ffffff',
				'selectors' => array(
					'{{WRAPPER}} .azo-images-widget .title-wrappe' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'name_style',
			array(
				'label' => esc_html__( 'Name', 'azo' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'name_color',
			array(
				'label'     => esc_html__( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#333333',
				'selectors' => array(
					'{{WRAPPER}} .images--name' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'name_typo',
				'selector' => '{{WRAPPER}} .images--name',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'content_style',
			array(
				'label'     => esc_html__( 'Description', 'azo' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'description' => 'yes',
				),
			)
		);

		$this->add_control(
			'content_color',
			array(
				'label'     => esc_html__( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#757575',
				'selectors' => array(
					'{{WRAPPER}} .main-content' => 'color: {{VALUE}}',
				),
				'condition' => array(
					'description' => 'yes',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'      => 'content_typo',
				'selector'  => '{{WRAPPER}} .main-content',
				'condition' => array(
					'description' => 'yes',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'alll_style',
			array(
				'label' => esc_html__( 'Icon Color', 'azo' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'pri_color',
			array(
				'label'     => esc_html__( 'Color Primary Icon', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#72747c',
				'selectors' => array(
					'{{WRAPPER}} .azo-images-widget .arrows-widget .azo-arrow:before' => 'color: {{VALUE}}',
					'{{WRAPPER}} .azo-images-widget .arrows-widget .azo-arrow' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .azo-images-widget .testi-arrow-widget .azo-arrows:before' => 'color: {{VALUE}}',
					'{{WRAPPER}} .azo-images-widget .slick-dots li' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'pri_hover_color',
			array(
				'label'     => esc_html__( 'Color Hover Primary Icon', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#ffb700',
				'selectors' => array(
					'{{WRAPPER}} .images--rate .fa-star:before' => 'color: {{VALUE}}',
					'{{WRAPPER}} .azo-images-widget .arrows-widget .azo-arrow:hover' => 'background-color: {{VALUE}};border-color: {{VALUE}};',
					'{{WRAPPER}} .azo-images-widget .arrows-widget .azo-arrow:focus' => 'background-color: {{VALUE}};border-color: {{VALUE}};',
					'{{WRAPPER}} .azo-images-widget .testi-arrow-widget .azo-arrows:hover:before' => 'color: {{VALUE}}',
					'{{WRAPPER}} .azo-images-widget .testi-arrow-widget .azo-arrows:focus:before' => 'color: {{VALUE}}',
					'{{WRAPPER}} .azo-images-widget .slick-dots .slick-active' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_section();
	}

	/**
	 * Render
	 */
	public function render() {
		$settings = $this->get_settings_for_display();

		$href = '#';
		$attr = '';
		if ( ! empty( $settings['link']['url'] ) ) {
			$href = $settings['link']['url'];

			if ( 'on' === $settings['link']['is_external'] ) {
				$attr .= ' target="_blank"';
			}

			if ( 'on' === $settings['link']['nofollow'] ) {
				$attr .= ' rel="nofollow"';
			}
		}
		?>
		<div class="azo-images-widget">
			<div class="images-slider-wrapper" data-show="<?php echo esc_attr( $settings['slides_to_show'] ); ?>" data-show-tablet="<?php echo esc_attr( $settings['slides_to_show_tablet'] ); ?>" data-show-mobile="<?php echo esc_attr( $settings['slides_to_show_mobile'] ); ?>" >
				<div class="title-wrappe">
					<h2 class="title-images"><?php echo esc_html( $settings['title'] ); ?></h2>
					<?php if ( 'yes' === $settings['arrows'] ) { ?>
						<div class="arrows-widget">
							<button class="azo-arrow arrows-prev"></button>
							<button class="azo-arrow arrows-next"></button>
						</div>
					<?php } ?>
				</div>

				<div class="js-images-slider images-list" >
					<?php foreach ( $settings['images'] as $image_caazoel ) { ?>
							<div class="images-item">
								<div class="images-order">
									<div class="images-slider">
										<a href="<?php echo esc_url( $href ); ?>">
											<img src="<?php echo esc_url( $image_caazoel['images_image']['url'] ); ?>" alt="<?php echo esc_attr( $image_caazoel['name'] ); ?>" class="slider-images">
										</a>
									</div>

									<div class="images-info">
										<a href="<?php echo esc_url( $href ); ?>" class="images--name">
											<?php echo esc_html( $image_caazoel['name'] ); ?>
										</a>
										<?php if ( 'yes' === $settings['description'] ) { ?>
											<span class="main-content"><?php echo esc_html( $image_caazoel['content'] ); ?></span>
										<?php } ?>
									</div>
								</div>
							</div>
					<?php } ?>
				</div>
			</div>
		</div>
		<?php
	}
}
Plugin::instance()->widgets_manager->register_widget_type( new Azo_Images_Slider() );

