<?php
/**
 * Azo Gallery Widget
 *
 * @package azo
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class for azo elementor product images widget.
 */
class Azo_Gallery extends \Elementor\Widget_Base {
	/**
	 * Category
	 */
	public function get_categories() {
		return array( 'azo-theme' );
	}

	/**
	 * Name
	 */
	public function get_name() {
		return 'azo-gallery';
	}

	/**
	 * Gets the title.
	 */
	public function get_title() {
		return __( 'Gallery', 'azo' );
	}

	/**
	 * Gets the icon.
	 */
	public function get_icon() {
		return 'eicon-gallery-grid';
	}

	/**
	 * Retrieve the list of scripts the widget depended on
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return array( 'azo-gallery' );
	}

	/**
	 * Controls
	 */
	protected function register_controls() { //phpcs:ignore
		// Labels.
		$this->start_controls_section(
			'section_gallery',
			array(
				'label' => esc_html__( 'Gallery', 'azo' ),
			)
		);
		$this->add_control(
			'column',
			array(
				'label'   => esc_html__( 'Columns', 'azo' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '2-columns',
				'options' => array(
					'2-columns' => esc_html__( '2 columns', 'azo' ),
					'3-columns' => esc_html__( '3 columns', 'azo' ),
					'4-columns' => esc_html__( '4 columns', 'azo' ),
				),
			)
		);
		$this->add_control(
			'allow_filter',
			array(
				'label'        => esc_html__( 'Filter ', 'azo' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => 'no',
				'label_on'     => esc_html__( 'Yes', 'azo' ),
				'label_off'    => esc_html__( 'No', 'azo' ),
				'return_value' => 'yes',
			)
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'label',
			array(
				'label'       => esc_html__( 'Label', 'azo' ),
				'description' => esc_html__( 'Add label for widget filter mode , do not enter existed one', 'azo' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Your Image Field...', 'azo' ),
				'default'     => esc_html__( 'Makeup', 'azo' ),
			)
		);
		$repeater->add_control(
			'images',
			array(
				'label'   => __( 'Add Images', 'azo' ),
				'type'    => Controls_Manager::GALLERY,
				'default' => array(),
			)
		);
		$this->add_control(
			'gallery',
			array(
				'label'       => esc_html__( 'Labels and images', 'azo' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => array(
					array(),
					array(),
				),
				'title_field' => '{{{ label }}}',
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'item_style',
			array(
				'label' => esc_html__( 'Item', 'azo' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_responsive_control(
			'item_height',
			array(
				'label'      => __( 'Item Height', 'azo' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 1000,
						'step' => 5,
					),
				),
				'default'    => array(
					'size' => 540,
				),
				'selectors'  => array(
					'{{WRAPPER}} .azo-gallery-archive .gall-thumb' => 'height: {{SIZE}}{{UNIT}};',
				),
			)
		);
		$this->add_responsive_control(
			'gap',
			array(
				'label'     => __( 'Item Padding', 'azo' ),
				'type'      => Controls_Manager::SLIDER,
				'default'   => array(
					'size' => 0,
				),
				'range'     => array(
					'px' => array(
						'min' => 0,
						'max' => 50,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .azo-gallery-archive .gall-thumb' => 'padding: {{SIZE}}{{UNIT}};',
				),
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'label_style',
			array(
				'label' => esc_html__( 'Filters', 'azo' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_responsive_control(
			'labels_align',
			array(
				'label'     => esc_html__( 'Alignment', 'azo' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'azo' ),
						'icon'  => 'fa fa-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'azo' ),
						'icon'  => 'fa fa-align-center',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'azo' ),
						'icon'  => 'fa fa-align-right',
					),
				),
				'default'   => 'left',
				'selectors' => array(
					'{{WRAPPER}} .azo-gallery-widget__label' => 'text-align: {{VALUE}}',
				),
			)
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'label_typo',
				'selector' => '{{WRAPPER}} .azo-gallery-widget__label span',
			)
		);
		$this->add_control(
			'labels_color',
			array(
				'label'     => esc_html__( 'Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#9e9e9e',
				'selectors' => array(
					'{{WRAPPER}} .azo-gallery-widget__label span' => 'color: {{VALUE}}',
				),
			)
		);
		$this->add_control(
			'labels_color_active',
			array(
				'label'     => esc_html__( 'Active Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#3a3b59',
				'selectors' => array(
					'{{WRAPPER}} .azo-gallery-widget__label span:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .azo-gallery-widget__label span.active-image' => 'color: {{VALUE}}',
				),
			)
		);
		$this->add_responsive_control(
			'labels_margin',
			array(
				'label'      => esc_html__( 'Margin', 'azo' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', 'em', '%' ),
				'default'    => array(
					'top'    => '0',
					'right'  => '30',
					'bottom' => '25',
					'left'   => '0',
					'unit'   => 'px',
				),
				'selectors'  => array(
					'{{WRAPPER}} .azo-gallery-widget__label span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				),
				'condition'  => array(
					'allow_filter' => 'yes',
				),
			)
		);
		$this->end_controls_section();
	}

	/**
	 * Render
	 */
	public function render() {
		$settings = $this->get_settings_for_display();
		$gallery  = $settings['gallery'];
		$filter   = $settings['allow_filter'];
		$columns  = $settings['column'];
		?>
		<div class="azo-gallery-widget">
			<?php if ( 'yes' === $filter ) : ?>
			<div class="azo-gallery-widget__label">
				<span data-filter="*" class="active-image" >All</span>
				<?php foreach ( $gallery as $gall ) : ?>
					<?php $label = $gall['label']; ?>
					<span data-filter=".<?php echo esc_attr( $label ); ?>" ><?php echo esc_html( $label ); ?></span>
				<?php endforeach; ?>
			</div>
			<?php endif; ?>
			<div class="azo-gallery-archive azo-gallery-archive--<?php echo esc_attr( $columns ); ?>">
				<?php foreach ( $gallery as $gall ) : ?>
					<?php foreach ( $gall['images'] as $image ) : ?>
						<?php
							$label     = $gall['label'];
							$image_url = $image['url'];
						?>
						<div class="gall-thumb <?php echo esc_attr( $label ); ?>">
							<div class="gall-thumb__inner">
								<img src="<?php echo esc_url( $image_url ); ?>" alt="<?php esc_attr_e( 'gall-image', 'azo' ); ?>">
								<a 	class="gall-thumb__inner__url"
									href="<?php echo esc_url( $image_url ); ?>"
								>
									<?php echo esc_html( $label ); ?>
								</a>
							</div>
						</div>
					<?php endforeach ?>
				<?php endforeach ?>
			</div>
		</div>
		<?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Azo_Gallery() );
