<?php
/**
 * Elementor Azo Breadcrumb
 *
 * @package azo
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

if ( ! defined( 'WC_PLUGIN_FILE' ) ) {
	return;
}

/**
 * Azo Widget Breadcrumb
 */
class Azo_Breadcrumb extends Widget_Base {

	/**
	 * Get categories
	 */
	public function get_categories() {
		return array( 'azo-theme' );
	}

	/**
	 * Get name
	 */
	public function get_name() {
		return 'breadcrumb';
	}

	/**
	 * Get title
	 */
	public function get_title() {
		return esc_html__( 'WooCommerce Breadcrumbs Azo', 'azo' );
	}

	/**
	 * Get Icon
	 */
	public function get_icon() {
		return 'eicon-product-breadcrumbs';
	}

	protected function _register_controls() { //phpcs:ignore
		$this->section_general();
	}

	/**
	 * Section general
	 */
	private function section_general() {
		$this->start_controls_section(
			'product_content',
			array(
				'label' => esc_html__( 'General', 'azo' ),
			)
		);

		$this->add_control(
			'pagination_text_align',
			array(
				'label'     => esc_html__( 'Alignment', 'azo' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'azo' ),
						'icon'  => 'fa fa-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'azo' ),
						'icon'  => 'fa fa-align-center',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'azo' ),
						'icon'  => 'fa fa-align-right',
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .woocommerce-breadcrumb' => 'text-align:{{VALUE}}',
				),
				'default'   => 'center',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'title_typo',
				'selector' => '{{WRAPPER}} .woocommerce-breadcrumb a, .woocommerce-breadcrumb',
			)
		);

		$this->add_control(
			'title_color',
			array(
				'label'     => esc_html__( 'Title Color', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .woocommerce-breadcrumb' => 'color: {{VALUE}}',
				),
				'default'   => '#959595',
			)
		);

		$this->add_control(
			'title_color_link',
			array(
				'label'     => esc_html__( 'Title Color Link', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .woocommerce-breadcrumb a' => 'color: {{VALUE}}',
				),
				'default'   => '#2f2f30',
			)
		);

		$this->add_control(
			'title_color_hover',
			array(
				'label'     => esc_html__( 'Title Color Hover', 'azo' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .woocommerce-breadcrumb a:hover' => 'color: {{VALUE}}',
				),
				'default'   => '#5c9372',
			)
		);

		$this->end_controls_section();
	}

	/**
	 * Render
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		if ( defined( 'WC_PLUGIN_FILE' ) ) {
			woocommerce_breadcrumb();
		}
	}
}
Plugin::instance()->widgets_manager->register_widget_type( new Azo_Breadcrumb() );
