<?php
/**
 * Comments
 *
 * @package azo
 */

if ( post_password_required() ) {
	return;
}

$layout        = get_theme_mod( 'post_style', 'poststyle1' );
$layout_preset = isset( $_GET['post_preset'] ) ? Azo_Helper::data_clean( $_GET['post_preset'] ) : false;
$container     = '';
if ( is_single() && ( 'poststyle2' === $layout || 'preset2' === $layout_preset ) ) {
	$container = 'container-poststyle2';
}

?>
<div id="comments" class="comments-area <?php echo esc_attr( $container ); ?>">
	<?php
	// You can start editing here -- including this comment!
	if ( have_comments() ) :
		?>
		<div class="comments-wrap">
			<h3 class="comments-title">
				<?php echo sprintf( _nx( '1 comment <span class="text-comments"></span>', '%s comments <span class="text-comments"></span>', get_comments_number(), 'comment count', 'azo' ), get_comments_number() ); //phpcs:ignore ?>
			</h3>

			<div class="comment-list-wrap">
				<ol class="comment-list">
					<?php
					wp_list_comments(
						array(
							'style'       => 'ol',
							'callback'    => 'azo_comment_list',
							'short_ping'  => true,
							'avatar_size' => '60',
						)
					);
					?>
				</ol>
			</div>
		</div>
		<?php
	endif;

	// If comments are closed and there are comments, let's leave a little note, shall we?
	if ( ! comments_open() ) { /*comment disable*/
		?>
		<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'azo' ); ?></p>
		<?php
		/*comment form*/
	} else {
		?>
		<div class="comment-form-wrap">
			<?php Azo_Templates::comment_form(); ?>
		</div>
		<?php
	}
	?>
</div>
