/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 46);
/******/ })
/************************************************************************/
/******/ ({

/***/ 46:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/* ==========================================================
 * edit.js
 * ==========================================================
 * Copyright 2018 Awesome Motive.
 * https://awesomemotive.com
 * ========================================================== */
jQuery(document).ready(function ($) {

	// Initialize Select2.
	omapiSelect();

	// Hide/show any state specific settings.
	omapiToggleSettings();

	// Support Toggles on content
	omapiSettingsToggle();

	// Confirm resetting settings.
	omapiResetSettings();

	// Copy to clipboard Loading
	omapiClipboard();

	// Recognize Copy to Clipboard Buttons
	omapiCopytoClipboardBtn();

	// Support PDF generation
	omapiBuildSupportPDF();

	// Run Tooltip lib on any tooltips
	omapiFindTooltips();

	// Add "Connect to OptinMonster" functionality
	omapiHandleApiKeyConnect();

	omapiInitInstallButtons();

	/**
  * Add the listeners necessary for the connect to OptinMonster button
  */
	function omapiHandleApiKeyConnect() {
		function updateForm(val, $btn) {
			var field = document.getElementById('omapi-field-apikey');
			field.value = val;

			// Start spinner.
			$('.om-api-key-spinner').remove();
			$btn.after('<div class="om-api-key-spinner spinner is-active" style="float: none;margin-top: -1px;"></div>');

			if (window.sessionStorage) {
				sessionStorage.removeItem('omTemplates');
				sessionStorage.removeItem('omTemplatesAuth');
			}

			HTMLFormElement.prototype.submit.call(field.form);
		}

		var $btn = $('#omapiAuthorizeButton').click(function (e) {
			e.preventDefault();
			try {
				var url = OMAPI.app_url + 'wordpress/connect/?site=' + encodeURIComponent(OMAPI.blogname);
				var w = window.open(url, '_blank', 'location=no,width=500,height=730,scrollbars=0');
				w.focus();
			} catch (e) {
				if (!OMAPI.autoconnect) {
					alert('Your browser blocked the authorization window from opening. Please check your popup settings.');
				}
			}
			OMAPI.autoconnect = false;
		});

		if (OMAPI.autoconnect) {
			$btn.trigger('click');
		}

		window.addEventListener('message', function (msg) {
			if (msg.origin.replace(/\/$/, '') !== OMAPI.app_url.replace(/\/$/, '')) {
				return;
			}

			if (!msg.data || 'string' !== typeof msg.data) {
				console.error('Messages from "' + OMAPI.app_url + '" must contain an api key string.');
				return;
			}

			updateForm(msg.data, $('#omapiAuthorizeButton'));
		});

		// Also initialize the "Click Here to enter an API Key" link
		$('#omapiShowApiKey').click(function (e) {
			e.preventDefault();
			$('#omapi-form-api .omapi-hidden').removeClass('omapi-hidden');
			$('#omapi-field-apikey').focus().select();
		});

		// Add the listener for disconnecting the API Key.
		$('#omapiDisconnectButton').click(function (e) {
			e.preventDefault();
			updateForm('', $(this));
		});
	}

	/**
  * Dynamic Toggle functionality
  */
	function omapiSettingsToggle() {

		$('.omapi-ui-toggle-controller').click(function (e) {
			var thisToggle = e.currentTarget;
			$(thisToggle).toggleClass("toggled");
			$(thisToggle).next(".omapi-ui-toggle-content").toggleClass("visible");
		});
	}

	/**
  * Confirms the settings reset for the active tab.
  *
  * @since 1.0.0
  */
	function omapiResetSettings() {
		$(document).on('click', 'input[name=reset]', function (e) {
			return confirm(omapi.confirm);
		});
	}

	/**
  * Toggles the shortcode list setting.
  *
  * @since 1.1.4
  */
	function omapiToggleSettings() {
		var shortcode_val = $('#omapi-field-shortcode').is(':checked');
		if (!shortcode_val) {
			$('.omapi-field-box-shortcode_output').hide();
		}
		$(document).on('change', '#omapi-field-shortcode', function (e) {
			if ($(this).is(':checked')) {
				$('.omapi-field-box-shortcode_output').show(0);
			} else {
				$('.omapi-field-box-shortcode_output').hide(0);
			}
		});

		var mailpoet_val = $('#omapi-field-mailpoet').is(':checked');
		if (!mailpoet_val) {
			$('.omapi-field-box-mailpoet_list').hide();
		}
		$(document).on('change', '#omapi-field-mailpoet', function (e) {
			if ($(this).is(':checked')) {
				$('.omapi-field-box-mailpoet_list').show(0);
			} else {
				$('.omapi-field-box-mailpoet_list').hide(0);
			}
		});

		var automatic_val = $('#omapi-field-automatic').is(':checked');
		if (automatic_val) {
			$('.omapi-field-box-automatic_shortcode').hide();
		}
		$(document).on('change', '#omapi-field-automatic', function (e) {
			if ($(this).is(':checked')) {
				$('.omapi-field-box-automatic_shortcode').hide(0);
			} else {
				$('.omapi-field-box-automatic_shortcode').show(0);
			}
		});
	}

	/**
  * Initializes the Select2 replacement for select fields.
  *
  * @since 1.0.0
  */
	function omapiSelect() {
		$('.omapi-select').each(function (i, el) {
			var data = $(this).attr('id').indexOf('taxonomies') > -1 ? OMAPI.tags : OMAPI.posts;
			$(this).select2({
				minimumInputLength: 1,
				multiple: true,
				data: data,
				initSelection: function initSelection(el, cb) {
					var ids = $(el).val();
					ids = ids.split(',');
					items = data.filter(function (d) {
						return ids.indexOf(d.id) > -1;
					});
					cb(items);
				}
			}).on('change select2-removed', function () {});
		});
	}

	/**
  * Generate support PDF from localized data
  *
  * @since 1.1.5
  */
	function omapiBuildSupportPDF() {
		var $selector = $('#js--omapi-support-pdf');

		var generateDoc = function generateDoc(data) {
			var doc = new jsPDF('p', 'mm', 'letter');

			// Doc Title
			doc.text(10, 10, 'OptinMonster Support Assistance');

			// Server Info
			var i = 10;
			$.each(data.server, function (key, value) {
				i += 10;
				doc.text(10, i, key + ' : ' + value);
			});

			// Optin Info
			$.each(data.campaigns, function (key, value) {

				// Move down 10mm
				var i = 10;
				// Add a new page
				doc.addPage();
				// Title as slug
				doc.text(10, 10, key);
				$.each(value, function (key, value) {

					// Keep from outputing ugly Object text
					var output = $.isPlainObject(value) ? '' : value;
					// new line
					i += 10;
					doc.text(10, i, key + ' : ' + output);
					// Output any object data from the value
					if ($.isPlainObject(value)) {
						$.each(value, function (key, value) {
							i += 10;
							doc.text(20, i, key + ' : ' + value);
						});
					}
				});
			});

			// Save the PDF
			doc.save('OMSupportHelp.pdf');
		};

		$selector.click(function (e) {
			e.preventDefault();

			// Start spinner.
			$('.om-api-key-spinner').remove();
			$selector.after('<div class="om-api-key-spinner spinner is-active" style="float: none;margin-top:7px;"></div>');

			$.ajax({
				url: omapi.root + 'omapp/v1/support?format=pdf',
				beforeSend: function beforeSend(xhr) {
					return xhr.setRequestHeader('X-WP-Nonce', omapi.nonce);
				},
				dataType: 'json',
				data: { format: 'pdf' },
				success: generateDoc
			}).done(function () {
				return $('.om-api-key-spinner').remove();
			}).fail(function (jqXHR, textStatus) {
				return console.error({ jqXHR: jqXHR, textStatus: textStatus });
			});
		});
	}

	/**
  * Clipboard Helpers
  *
  * @since 1.1.5
  */
	function omapiClipboard() {
		var ompaiClipboard = new Clipboard('.omapi-copy-button');

		ompaiClipboard.on('success', function (e) {
			setTooltip(e.trigger, 'Copied to Clipboard!');
			hideTooltip(e.trigger);
		});
		ompaiClipboard.on('error', function (e) {
			var fallbackMessage = '';

			if (/iPhone|iPad/i.test(navigator.userAgent)) {
				fallbackMessage = 'Unable to Copy on this device';
			} else if (/Mac/i.test(navigator.userAgent)) {
				fallbackMessage = 'Press ⌘-C to Copy';
			} else {
				fallbackMessage = 'Press Ctrl-C to Copy';
			}
			setTooltip(e.trigger, fallbackMessage);
			hideTooltip(e.trigger);
		});
	}

	/**
  * Standardize Copy to clipboard button
  *
  * @since 1.1.5
  */
	function omapiCopytoClipboardBtn() {
		$('omapi-copy-button').tooltip({
			trigger: 'click',
			placement: 'top'

		});
	}
	/**
  * Set BS Tooltip based on Clipboard data
  *
  * @since 1.1.5
  * @param btn
  * @param message
  */
	function setTooltip(btn, message) {
		$(btn).attr('data-original-title', message).tooltip('show');
	}

	/**
  * Remove tooltip after Clipboard message shown
  *
  * @since 1.1.5
  * @param btn
  */
	function hideTooltip(btn) {
		setTimeout(function () {
			$(btn).tooltip('destroy');
		}, 2000);
	}

	function omapiFindTooltips() {
		$('[data-toggle="tooltip"]').tooltip();
	}

	function omapiInitInstallButtons() {
		$('.install-plugin-form').submit(function (e) {
			e.preventDefault();
			var fields = $(e.currentTarget).serializeArray();
			var nonce = fields.find(function (field) {
				return 'nonce' === field.name;
			}).value;
			var plugin = fields.find(function (field) {
				return 'plugin' === field.name;
			}).value;
			var pluginClassName = plugin.replace('.', '').replace('/', '');
			var installAction = fields.find(function (field) {
				return 'action' === field.name;
			}).value;
			var url = fields.find(function (field) {
				return 'url' === field.name;
			}).value;
			var el = $('.omapi-plugin-recommendation--' + pluginClassName);

			if (!el.length) {
				el = $('html');
			}

			$('.button-install', el).html('Installing...');
			$('.button-activate', el).html('Activating...');
			$('#om-plugin-alerts').hide();

			$.post(ajaxurl, {
				action: 'om_plugin_install',
				'optin-monster-ajax-route': true,
				nonce: nonce,
				plugin: plugin,
				installAction: installAction,
				url: url
			}, function (data) {
				if (data.success) {
					window.location.reload();
				} else {
					$('.button-install', el).html('Install Plugin');
					$('.button-activate', el).html('Activate Plugin');

					$('#om-plugin-alerts').show().html($('<p/>').html(data.data || 'Something went wrong!'));
				}
			});
		});
	}
});

/***/ })

/******/ });