<?php
/**
 * Azo Video Product
 *
 * @package azo
 */

/**
 * Metaboxs
 */
function azo_add_custom_box() {
	$screens = array( 'post', 'azo_cpt' );
	foreach ( $screens as $screen ) {
		add_meta_box(
			'azo_product_video_metabox',
			__( 'Product video url', 'azo' ),
			'azo_product_metabox_content',
			'product',
			'side'
		);
	}
}
add_action( 'add_meta_boxes', 'azo_add_custom_box' );

/**
 * Azo product metabox content
 *
 * @param  [type] $post type.
 */
function azo_product_metabox_content( $post ) {
	// Add a nonce field so we can check for it later.
	wp_nonce_field( basename( __FILE__ ), 'azo_product_video_metabox_nonce' );
	$value = get_post_meta( $post->ID, 'azo_product_video_metabox', true );
	?>
	<div class="azo-metabox-setting">
		<div class="azo-metabox-option-content">
			<label for="azo-product-video-url" style="margin-top: 10px; display: block;">
				<textarea class="widefat" id="azo-product-video-url" name="azo_product_video_metabox" rows="4" placeholder="<?php esc_attr_e( 'Enter Youtube or Vimeo video url', 'azo' ); ?>" ><?php echo esc_attr( $value ); ?></textarea>
			</label>
		</div>
	</div>
	<?php
}

/**
 * Save metaboxs
 *
 * @param int $post_id The post identifier.
 */
function azo_save_product_metaboxes( $post_id ) {
	$is_autosave    = wp_is_post_autosave( $post_id );
	$is_revision    = wp_is_post_revision( $post_id );
	$is_valid_nonce = ( isset( $_POST['azo_product_video_metabox_nonce'] ) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['azo_product_video_metabox_nonce'] ) ), basename( __FILE__ ) ) ) ? true : false;

	// Exits script depending on save status.
	if ( $is_autosave || $is_revision || ! $is_valid_nonce ) {
		return;
	}

	// Sanitize user input.
	$video = empty( $_POST['azo_product_video_metabox'] ) ? '' : sanitize_text_field( wp_unslash( $_POST['azo_product_video_metabox'] ) );
	update_post_meta( $post_id, 'azo_product_video_metabox', $video );
}
add_action( 'save_post', 'azo_save_product_metaboxes' );

if ( ! function_exists( 'azo_get_metabox' ) ) {
	/**
	 * Get metabox option
	 *
	 * @param int    $page_id      The page ID.
	 * @param string $metabox_name Metabox option name.
	 */
	function azo_get_metabox( $page_id = false, $metabox_name ) {
		$page_id             = $page_id ? intval( $page_id ) : azo_get_page_id();
		$metabox             = get_post_meta( $page_id, $metabox_name, true );
		$is_product_category = class_exists( 'woocommerce' ) && is_product_category();

		if ( ! $metabox || $is_product_category ) {
			$metabox = 'default';
		}

		return $metabox;
	}
}

